#ifndef _GRAF_PLAYER_APP
#define _GRAF_PLAYER_APP


#include "ofMain.h"
#include "grafTagMulti.h"
#include "grafIO.h"
#include "grafPlayer.h"
#include "grafCurveSmoother.h"
#include "grafDrawer.h"
#include "pocoDirectoryLister.h"
#include "grafVParticleField.h"
#include "ofxControlPanel.h"
#include "ofxXmlSettings.h"
#include "ofThreadedImage.h"

//includes for the rss feed loader hack
#include "Poco/Net/HTTPClientSession.h"
#include "Poco/Net/HTTPRequest.h"
#include "Poco/Net/HTTPResponse.h"
#include "Poco/StreamCopier.h"
#include "Poco/Path.h"
#include "Poco/File.h"
#include "Poco/URI.h"
#include "Poco/Exception.h"
#include "Poco/RegularExpression.h"
#include "Poco/URIStreamOpener.h"
#include "Poco/Net/HTTPStreamFactory.h"
#include "Poco/XML/XMLString.h"
#include "Poco/DOM/DOMParser.h"
#include "Poco/DOM/Document.h"
#include "Poco/DOM/NodeIterator.h"
#include "Poco/DOM/NodeFilter.h"
#include "Poco/DOM/NamedNodeMap.h"
#include <iostream>
#include <fstream>
using Poco::Net::HTTPClientSession;
using Poco::Net::HTTPRequest;
using Poco::Net::HTTPResponse;
using Poco::Net::HTTPMessage;
using Poco::StreamCopier;
using Poco::Path;
using Poco::File;
using Poco::URI;
using Poco::Exception;
using Poco::RegularExpression;
using Poco::URIStreamOpener;
using Poco::Net::HTTPStreamFactory;
using Poco::XML::XMLString;
using Poco::XML::DOMParser;
using Poco::XML::Document;
using Poco::XML::NodeIterator;
using Poco::XML::NodeFilter;
using Poco::XML::Node;
using Poco::XML::NamedNodeMap;


#define TAG_DIRECTORY	"tags/"

enum{ PLAY_MODE_LOAD, PLAY_MODE_PLAY };

class grafPlayerApp{

	public:

		grafPlayerApp();
		~grafPlayerApp();
		void setup();
		void update();
		void draw();
	
		//functions for the rss feed loader hack
		void getGuidValues( const std::string& result, std::vector<int>* dest ); //thx v
		bool makeDirectory( string dirPath, bool bRelativeToData ); //found on web, from zach
		void loadTagsFromRSS( const std::string& thisword );


		void keyPressed  (int key);
		void keyReleased(int key);
		void mouseMoved(int x, int y );
		void mouseDragged(int x, int y, int button);
		void mousePressed(int x, int y, int button);
		void mouseReleased(int x, int y, int button);
		
		void preLoadTags();
		void loadTags();
	
		void resetPlayer(int next);
		void nextTag(int dir=1);
		void clearAll();
	
		void setupContolPanel();
		void updateConrolPanel();
		
		string getCurrentTagName();
	
	
		//---------- loading data
		grafIO					gIO;					// gml loader/saver
		ofxPocoDirectoryLister	dirLister;				// searches directory for gml files
		string					myTagDirectory;			// directory to load from (changeable in data/settings/directorySettings.xml
		int						totalToLoad;			// totalFiles found to load
		vector<string>			filesToLoad;			// list of all file paths
		vector<string>			filenames;				// list of corresponding file names (sans .gml)
	
	
	
		//---------- gml tags
		vector<grafTagMulti> tags;						
	
		//---------- player to animate the tag 
		grafPlayer	myTagPlayer;					
		
		//---------- smooths curve for nice drawing
		grafCurveSmoother smoother;
	
		//---------- drawing
		grafDrawer			drawer;					// draws thick time stroked line
		grafVParticleField	particleDrawer;			// draws and animates particles
		float				rotationY;				// y rotation for current tag
		ofPoint				tagPosVel;				// vel for moving tag around on screen
		float				tagMoveForce;			// force for moving tag around
		ofTrueTypeFont		fontS;					// fonts for drawing info to screen
		ofTrueTypeFont		fontL;
		ofTrueTypeFont		fontSS;
		int					prevStroke;				// for multi stroke tags, to help particle animation
		float				fogStart,fogEnd;		// fog settings
		float				dt;
		ofImage				imageMask;
	
	
		//---------- id of the current tag being played
		int currentTagID;
	
		//---------- 
		float					waitTimer;			// counter to pause after animation finished
		float					waitTime;			// time to pause
		
		//---------- application settings
        bool            bShiftOn;
		int             screenW,screenH;
		float			lastX,lastY;
		ofxThreadedImageSaver imgsaver;
	

		//---------- controls
		ofxControlPanel		panel;
		bool				bShowPanel;			// toggle panel on/off
		bool				bRotating;			// toggle auto rotation on/off
		bool				bShowName;			// toggle filename displa
		bool				bShowTime;			// toggle time display
		bool				bUseFog;			// toggle fog
		bool				bUseMask;			// toggle edge masking
		bool				bTakeScreenShot;	
		bool				bUseGravity;
	
		int					mode;				// current play mode PLAY_MODE_LOAD for loading, PLAY_MODE_PLAY for normal playback
	
	
	
	
	
};

#endif
