#include "grafIO.h"


grafIO::grafIO()
{
    //ctor
}

grafIO::~grafIO()
{
    //dtor
}

void grafIO::saveGrafTag( string directory, grafRecorder * src )
{

    cout << directory << endl;

    mkdir(ofToDataPath("tags/"+directory).c_str(),0777);

    ofxXmlSettings xml;

    xml.addTag("data");
    xml.pushTag("data",0);
        xml.setValue("position:x", src->position.x );
        xml.setValue("position:y", src->position.y );
        xml.setValue("position:z", src->position.z );

        xml.setValue("rotation:x", src->rotation.x );
        xml.setValue("rotation:y", src->rotation.y );
        xml.setValue("rotation:z", src->rotation.z );

        xml.setValue("z_const", src->z_const );
    xml.popTag();

    xml.addTag("recording");
    xml.pushTag("recording",0);

    int start   = src->getStartPt();
    int end     = src->getEndPt();


    for( int i=start; i<end; i++)
    {
        xml.addTag("pt");
        xml.pushTag("pt",i-start);
        xml.setValue("x",src->pts[i].pos.x);
        xml.setValue("y",src->pts[i].pos.y);
        xml.setValue("time",src->pts[i].time);
        xml.setValue("angle",src->angles[i]);
        xml.setValue("dist",src->dists[i]);
        xml.popTag();

    }

    xml.popTag();

    string xmlfile = "tags/"+directory + "/" + directory + ".graf";
    xml.saveFile( xmlfile );

    // save thumbnail
    ofImage * thumbnail = new ofImage();//ofGetWidth(),ofGetHeight());
    thumbnail->grabScreen(0,0,ofGetWidth(),ofGetHeight());
    thumbnail->saveImage( "tags/"+directory+"/"+directory+".jpg" );
    thumbnail->resize(160,120);
    thumbnail->saveImage( "tags/"+directory+"/"+directory+"_thumbnail.jpg" );

    delete thumbnail;
}

void grafIO::loadGrafTag( string folder, string directory, grafRecorder * dst )
{
    dst->clear();

    ofxXmlSettings xml;

    xml.loadFile( folder+ "/"+directory + "/" + directory + ".graf" );

    xml.pushTag("recording");
    int numPts = xml.getNumTags("pt");

    cout << "numpts " << numPts << endl;

    timePt pt;
    for( int i=0; i<numPts; i++)
    {
        xml.pushTag("pt",i);

        pt.pos.x = xml.getValue("x",0.f);
        pt.pos.y = xml.getValue("y",0.f);
        pt.time = xml.getValue("time",0.f);

        float angle = xml.getValue("angle",0.f);
        float dist  = xml.getValue("dist",0.f);

        if( i == numPts - 1) dist = 0;

        dst->addLoadedPoint(pt.pos, dist, -1, pt.time, false );
        //cout << "pt " << pt.pos.x << endl;

        xml.popTag();

    }

       xml.popTag();

        xml.pushTag("data",0);

        dst->position.x = xml.getValue("position:x", 0.f );
        dst->position.y = xml.getValue("position:y", 0.f );
        dst->position.z = xml.getValue("position:z", 0.f );

        dst->rotation.x = xml.getValue("rotation:x", 0.f );
        dst->rotation.y = xml.getValue("rotation:y", 0.f );
        dst->rotation.z = xml.getValue("rotation:z", 0.f );

    xml.popTag();

    dst->calcMinMax();

}


bool grafIO::loadGrafTagToEdit(grafRecorder * dst, int num)
{
    // check if there is a tag in the folder
    vector<string> dirs;

    PL.setPath( ofToDataPath("tags-edit/",true) );
    PL.findSubDirectories(dirs);

    if( dirs.size() > 0 )
    {
        num = num % (dirs.size());
        loadGrafTag( "tags-edit", dirs[num], dst);
        return true;
    }

    return false;
}

