#include "guiButtonGroup.h"

guiButtonGroup::guiButtonGroup()
{
    //ctor
}

guiButtonGroup::~guiButtonGroup()
{
    //dtor
}

void guiButtonGroup::setup( string groupname, int x_, int y_, int w_, int h_)
{
    groupName = groupname;
    x = x_;
    y = y_;
    w = w_;
    h = h_;

    currentOn = 0;
}


void guiButtonGroup::addButton(string name)
{
    guiButton button;
    buttons.push_back( button );

    int i = buttons.size()-1;
    buttons[ i ].setup( x,y+(i*(h+4)),w,h);

    if(  i == currentOn ) buttons[ i ].bOn = true;
    else  buttons[ i ].bOn = false;

    names.push_back(name);
}

int guiButtonGroup::update( int mx, int my)
{

    int newOn = currentOn;

    for( int i = 0; i < buttons.size(); i++)
    {
        if( buttons[i].update( mx, my ) )
        {
        newOn = i;
        continue;
        }
    }

    if( newOn != currentOn )
    {
        for( int i = 0; i < buttons.size(); i++) buttons[i].bOn = false;
    }

    currentOn = newOn;
    buttons[ currentOn ].bOn = true;

    return currentOn;

}

void guiButtonGroup::draw( )
{
    for( int i = 0; i < buttons.size(); i++)
    {
        if( i == currentOn ) ofFill();
        else ofNoFill();

        buttons[i].draw();
        ofDrawBitmapString(names[i], buttons[i].getX()+buttons[i].getW() + 4, buttons[i].getY() + 10);

    }
}


