#ifndef _TEST_APP
#define _TEST_APP


#include "ofMain.h"
#include "ofxOpenCv.h"
#include "ofxXmlSettings.h"

#include "vectorField.h"
#include "particleSystem.h"
#include "grafRecorder.h"
#include "tracker.h"
#include "grafEditor.h"
#include "grafIO.h"

enum{
MOUSE_NONE,MOUSE_ZOOM,MOUSE_TRANSLATE,MOUSE_ROTATE
};


class testApp : public ofBaseApp{

	public:

		testApp();
		void setup();
		void update();
		void draw();

		void keyPressed  (int key);
		void keyReleased(int key);
		void mouseMoved(int x, int y );
		void mouseDragged(int x, int y, int button);
		void mousePressed(int x, int y, int button);
		void mouseReleased(int x, int y, int button);
		void resized(int w, int h);

		void loadConfigSettings(string filename);
		void reset_vfield();
        void loadToEdit();

        //----------- video input
        ofBaseVideo     * videoSource;

		//---------- tracking
		tracker         * TR;

		//---------- vector field
        particleSystem  * PS;
		vectorField     * VF;

		//---------- point recording
		grafRecorder    * PR;
		grafEditor      * GE;

		//---------- save and load
		grafIO          * DM;

		//---------- application settings
		bool            bUseVideoFiles;
        bool            bUseMouseCapture;
        bool            bShowCVPanel;
        bool            bShowEditPanel;
        bool            bShowInfo;
        bool            bShiftOn;

        int             camW,camH,camId;
        int             screenW,screenH;
        float           lastX, lastY;
		int             mouse_mode;
        int             loadCounter;





};

#endif
