#include "tracker.h"

tracker::tracker()
{
    bFlipH = true;
    bFlipV = false;

    width  = 320;
    height = 240;

    threshold = 80.f;

	bUseDilate		= false;
	nDilations		= 1;

	mode = TRACK_BG_SUBTRACT;

}

tracker::~tracker()
{
    //dtor
}

void tracker::setup( int w, int h )
{
    width  = w;
    height = h;

    capturedImageData.allocate(w,h);
    grayImageData.allocate(w,h);
	backgroundData.allocate(w,h);
	thresholdImage.allocate(w,h);
    prevFrameImage.allocate(w,h);

    MD = new motionDifference(w, h, 80);

    setupGui();
}

void tracker::update( unsigned char * pixels)
{
    capturedImageData.setFromPixels(pixels, width,height);
    grayImageData.setFromColorImage( capturedImageData );
    grayImageData.mirror(bFlipV,bFlipH);

   /* if(bCaptureBg)
    {
         backgroundData = grayImageData;
         bCaptureBg = false;
    }*/

    //for motion detection object
	//MD->thresh  = threshold;
	//MD->difference(grayImageData.getPixels());
    //thresholdImage.setFromPixels( MD->mDif, thresholdImage.width, thresholdImage.height);

	int minArea     = 2;
    int maxArea     = (int)(width*height*.75);
    int nConsidered = 10;
    bool bFindHoles = false;
    bool bUseAprox  = false;

   grayImageData.contrastStretch();


    thresholdImage = grayImageData;

    // track brightest
	if( mode == TRACK_BRIGHT )
	{
        ;

	}else if( mode == TRACK_MOTION )
	{
	    thresholdImage.absDiff(prevFrameImage);
	    prevFrameImage = grayImageData;
	}else if( mode == TRACK_BG_SUBTRACT )
	{
        thresholdImage.absDiff(backgroundData);
	}


    thresholdImage.threshold( threshold );
    thresholdImage.dilate();
    thresholdImage.blurHeavily();
    thresholdImage.threshold(10);

    //if( mode == TRACK_BRIGHT ) thresholdImage.invert();
    contourFinder.findContours( thresholdImage, minArea, maxArea, nConsidered, bFindHoles, bUseAprox );


}

void tracker::draw()
{
    ofSetColor(255,255,255);
    grayImageData.draw(0,0);

    thresholdImage.draw(0,240);
    contourFinder.draw(0,0);

   // MD->draw(0,240,320,240);
    //ofNoFill();
    //ofSetColor(255,0,0);
    //if( contourFinder.nBlobs > 0 ) ofCircle( contourFinder.blobs[0].centroid.x, contourFinder.blobs[0].centroid.y,4);

    ofNoFill();
    ofSetColor(255,255,255);
    ofRect(0,0,320,240);
    ofRect(0,240,320,240);

    drawGui();

}

 float tracker::getX()
 {
     //return MD->centroid_x*width;// * 320 * 3.2;
     // * 320 * 3.2;
     if( contourFinder.nBlobs > 0 ) return contourFinder.blobs[0].centroid.x;
     return 0;
 }

float tracker::getY()
{
    //return MD->centroid_y*240;
    if( contourFinder.nBlobs > 0 ) return contourFinder.blobs[0].centroid.y;
    return 0;
}

void tracker::saveToXML( string filename )
{
    ofxXmlSettings xml;

    xml.setValue("threshold", threshold);

    xml.saveFile( filename );

}

void tracker::loadFromXML( string filename )
{
    ofxXmlSettings xml;
    xml.loadFile( filename );

    threshold = xml.getValue("threshold", threshold);


}

void tracker::setupGui()
{
    slider_threshold.setup( "Threshold", 80, 0, 255, 330, 30, 100, 10);

    button_mode.setup( "Capture Mode", 330, 60, 10, 10 );
    button_mode.addButton( "Brigthness" );
    button_mode.addButton( "Motion" );
    button_mode.addButton( "BG Subtraction" );
}

void tracker::drawGui()
{
    slider_threshold.draw();
    //button_mode.draw();
}

void tracker::updateGui()
{
    threshold = slider_threshold.getFloatValue();
}

void tracker::mouseMoved(int x, int y )
{

}

void tracker::mouseDragged(int x, int y, int button)
{

    if( slider_threshold.update(x,y) )
    {
         threshold = slider_threshold.getIntValue();
         cout << threshold << endl;
         return;
    }

}

void tracker::mousePressed(int x, int y, int button)
{
    mode = button_mode.update(x,y);
}

void tracker::mouseReleased(int x, int y, int button)
{

}
