#include "grafIO.h"


grafIO::grafIO()
{
    //ctor
}

grafIO::~grafIO()
{
    //dtor
}

void grafIO::saveGrafTag( string directory, grafTag * src )
{

    // create a directory for the files
    #ifdef TARGET_WIN32
        mkdir(ofToDataPath("tags/"+directory).c_str());
    #endif
    #ifdef TARGET_OSX
        // Yo Vanderlin --> need a mac make directory here
    #endif
    #ifdef TARGET_LINUX
        mkdir(ofToDataPath("tags/"+directory).c_str(),0777);
    #endif



    ofxXmlSettings xml;

   // save position and rotatin data
    xml.addTag("data");
    xml.pushTag("data",0);
        xml.setValue("position:x", src->position.x );
        xml.setValue("position:y", src->position.y );
        xml.setValue("position:z", src->position.z );

        xml.setValue("rotation:x", src->rotation.x );
        xml.setValue("rotation:y", src->rotation.y );
        xml.setValue("rotation:z", src->rotation.z );

        xml.setValue("z_const", src->z_const );
    xml.popTag();

    // save the points, time, angles, distances etc.
    xml.addTag("recording");
    xml.pushTag("recording",0);

    int start   = src->getStartPt();
    int end     = src->getEndPt();

    for( int i=start; i<end; i++) xml.addTag("pt");

    for( int i=start; i<end; i++)
    {
        xml.pushTag("pt",i);
        xml.setValue("x",src->pts[i].pos.x);
        xml.setValue("y",src->pts[i].pos.y);
        xml.setValue("time",src->pts[i].time);
        xml.setValue("angle",src->pts[i].angle);
        xml.setValue("dist",src->pts[i].dist);
        xml.popTag();

    }

    xml.popTag();

    string xmlfile = "tags/" + directory + "/" + directory + ".graf";
    xml.saveFile( xmlfile );

    // save thumbnail
    ofImage * thumbnail = new ofImage();//ofGetWidth(),ofGetHeight());
    thumbnail->grabScreen(0,0,ofGetWidth(),ofGetHeight());
    thumbnail->saveImage( "tags/" + directory+"/"+directory+".jpg" );
    thumbnail->resize(160,120);
    thumbnail->saveImage( "tags/" + directory+"/"+directory+"_thumbnail.jpg" );

    delete thumbnail;
}

void grafIO::loadGrafTag( string directory, grafTag * dst )
{

    // clear destination tag
    dst->clear();

    ofxXmlSettings xml;

    xml.loadFile( "tags/"+directory + "/" + directory + ".graf" );

    xml.pushTag("recording");
    int numPts = xml.getNumTags("pt");

    cout << "numpts " << numPts << endl;

    timePt pt;
    for( int i=0; i<numPts; i++)
    {
        xml.pushTag("pt",i);

        pt.pos.x = xml.getValue("x",0.f);
        pt.pos.y = xml.getValue("y",0.f);
        pt.time = xml.getValue("time",0.f);

        //float angle = xml.getValue("angle",0.f);
        //float dist  = xml.getValue("dist",0.f);

        //if( i == numPts - 1) dist = 0;

        dst->addNewPoint(pt.pos, -1, -1, pt.time );
        //cout << "pt " << pt.pos.x << endl;

        xml.popTag();

    }

       xml.popTag();

        xml.pushTag("data",0);

        dst->position.x = xml.getValue("position:x", 0.f );
        dst->position.y = xml.getValue("position:y", 0.f );
        dst->position.z = xml.getValue("position:z", 0.f );

        dst->rotation.x = xml.getValue("rotation:x", 0.f );
        dst->rotation.y = xml.getValue("rotation:y", 0.f );
        dst->rotation.z = xml.getValue("rotation:z", 0.f );

    xml.popTag();

    dst->calcMinMax();

}

void grafIO::loadTextTag( string filename, grafTag * dst )
{
    dst->clear();

    dataIO * IO = new dataIO();

    string file =  "data/texttags/" + filename + ".graf";
    IO->load_data( (char*)file.c_str() );

    int nPts = IO->n_pts;
    cout << "n_pts " << nPts << endl;

    for( int i = 0; i < nPts; i++)
    {
        //if( IO->skip_pts[i] == 1 )
        ////{
           // float x = IO->x_pts[i];
          //  float y = ;
           // if( dst->addNewPoint(  ofPoint( IO->x_pts[i]/1024.0,(768-IO->y_pts[i])/768.0,0 ),-1,-1, IO->t_pts[i]/1000.f) )
                ;//dst->pts[ dst->pts.size()-1 ].time = IO->t_pts[i]/1000.f;

       // }
    }

    //dst->resetForEditing();

    // save to xml
    saveGrafTag(filename,dst);

    delete IO;
}


void grafIO::saveScreenShot( string directory, grafTag * dst )
{
    PL.setPath( ofToDataPath("tags/",true) );
    PL.setExtensionToLookFor(".jpg");
    int num = PL.getNumberOfFiles();


    ofImage * sshot = new ofImage();//ofGetWidth(),ofGetHeight());

    sshot->grabScreen(0,0,ofGetWidth(),ofGetHeight());
    sshot->saveImage( "tags/" + directory+"/"+directory+"_"+ofToString(num)+".jpg" );

    delete sshot;
}

/*
dataIO * IO = new dataIO();

            string file =  "data/tags/" + filename + ".graf";
            IO->load_data( (char*)file.c_str() );

            int nPts = IO->n_pts;

            for( int i = 0; i <nPts; i++)
            {
                pts.push_back(  ofPoint(IO->x_pts[i],IO->y_pts[i]) );
                time_pts.push_back( IO->t_pts[i] );
                skip_pts.push_back( IO->skip_pts[i] );
            }

        delete IO;
        */
