#ifndef GUIMANAGER_H
#define GUIMANAGER_H

#include "guiSlider.h"
#include "guiButton.h"
#include "guiButtonGroup.h"
#include "ofxXmlSettings.h"

class guiManager
{
    public:
        guiManager();
        virtual ~guiManager();

        void draw();

        void addSlider( string name, float defVal, float min, float max, float x, float y, float w, float h);
        void addButton( string name, float x, float y, float w, float h, bool bOnOff);

        bool updateDrag( float mx, float my );
        bool updatePress( float mx, float my );

        float getFloatVal( string name );
        int getIntVal( string name );
        float getPctVal( string name );
        bool getButtonVal( string name );

        void saveDataToXML();
        void loadDataFromXML();

        vector<guiSlider> sliders;
        vector<guiButton> buttons;

    protected:
    private:
};

#endif // GUIMANAGER_H
