#ifndef GUISLIDER_H
#define GUISLIDER_H

#include "guiUtils.h"

class guiSlider
{
    public:
        guiSlider();
        guiSlider(string sliderName, float defaultVal, float min_, float max_);
        virtual ~guiSlider();

        void    setup( string sliderName, float defaultVal, float min_, float max_, float x, float y, float w_, float h_ );
        void    setup( float x, float y, float w_, float h_ );
        bool    update(int x, int y);
        bool    hitTest( int x, int y );
        void    draw();

        int     getIntValue();
        float   getFloatValue();
        float   getPctValue();

        void    setValue( float val );
        string getName(){ return name; };



    protected:


        string name;
        float value;
        float min;
        float max;
        float xpos,ypos;
        float w,h;

        ofRectangle hitArea;


    private:
};

#endif // GUISLIDER_H
