#include "testApp.h"
#include "stdio.h"

//--------------------------------------------------------------
testApp::testApp(){


    screenW = ofGetWidth();
    screenH = ofGetHeight();
    bShowFrameRate = false;

}

testApp::~testApp(){

    delete GM;

}
//--------------------------------------------------------------
void testApp::setup(){


    sW              = 1024;
	sH              = 768;
    loadConfigSettings( "settings/app_config.xml" );


    GM = new grafVisualManager();


	GM->setup(sW,sH);
    GM->loadTags();
	GM->setupGuiControls();


	//-----------
	lastX           = 0;
	lastY           = 0;
	mouse_mode      = 3;
	bShiftOn        = false;


    //-----------
    //ofSetFrameRate(60);
    ofBackground(0.0f, 0.0f, 0.0f);
   // ofSetVerticalSync(true);
    ofHideCursor();


}

//--------------------------------------------------------------
void testApp::update(){

    screenW = ofGetWidth();
    screenH = ofGetHeight();

    //ofBackground(0,0,0);


    GM->update();

}


//--------------------------------------------------------------
void testApp::draw(){


    glBlendFunc(GL_SRC_ALPHA,GL_ONE_MINUS_SRC_ALPHA);
    glEnable(GL_BLEND);
    glAlphaFunc(GL_NOTEQUAL, 0.0);

    GM->draw();


    if( bShowFrameRate )
    {
        glDisable(GL_DEPTH_TEST);
        glDisable(GL_FOG);
        ofSetColor(255,255,255,255);
        ofDrawBitmapString( ofToString( ofGetFrameRate(), 2 ),960,20);
    }

}


//--------------------------------------------------------------
void testApp::keyPressed  (int key){



    switch(key){

  		case 's':   GM->saveCurrent();  break;
  		case 'R':   GM->resetRotation(); break;


        case OF_KEY_RIGHT:  GM->nextTag(); break;
        case OF_KEY_LEFT:   GM->prevTag(); break;

        case 'i':   GM->saveScreen(); break;
        case 'w':   GM->writefile(); break;

        case 'f':   bShowFrameRate = !bShowFrameRate; break;
        case 'p':   GM->togglePaused(); break;
        case 'h':
            GM->bDisplayInfo = !GM->bDisplayInfo;
            GM->bDisplayGui = !GM->bDisplayGui;
            if(GM->bDisplayGui) ofShowCursor();
            else ofHideCursor();
            break;

        case 'F': ofToggleFullscreen(); break;

        case ' ':
            ofHideCursor();
            GM->bDisplayInfo    = false;
            GM->bDisplayGui     = false;
            bShowFrameRate      = false;
            break;

        default:
  			break;

  }



}

//--------------------------------------------------------------
void testApp::keyReleased(int key){

}

//--------------------------------------------------------------
void testApp::mouseMoved(int x, int y ){

	lastX   = x;
	lastY   = y;
}

//--------------------------------------------------------------
void testApp::mouseDragged(int x, int y, int button){


    if( GM->bDisplayGui ){
        GM->updateGuiDrag(x,y);
        if( x < 300 ) return;
    }

    if( button == 0 )
    {
        if( bShiftOn )
        {
            GM->adjustTagRot(x-lastX,0);
        }else{

             GM->adjustTagPos(x-lastX,y-lastY,0);
        }

    }else{


         if( bShiftOn )
        {
            GM->adjustTagRot(0,y-lastY);
        }else{

            GM->adjustTagPos(0,0,y - lastY);
        }
    }


	lastX   = x;
	lastY   = y;

}

//--------------------------------------------------------------
void testApp::mousePressed(int x, int y, int button){

    lastX = x;
	lastY = y;

	if(glutGetModifiers() == GLUT_ACTIVE_SHIFT) bShiftOn = true;

	GM->updateGuiPress(x,y);

}

//--------------------------------------------------------------
void testApp::mouseReleased(int x, int y, int button){

    bShiftOn = false;


}

//--------------------------------------------------------------
void testApp::resized(int w, int h){

}


void testApp::loadConfigSettings(string filename)
{
    ofxXmlSettings  xml;

    sW = xml.getValue("screenW",sW);
    sH = xml.getValue("screenH",sH);
    xml.loadFile(filename);


}
