#ifndef GRAFVISUALMANAGER_H
#define GRAFVISUALMANAGER_H

#include "ofMain.h"
#include "grafTag.h"
#include "grafIO.h"
#include "pocoDirectoryLister.h"
#include "grafParticleVecField.h"
#include "grafCurveSmoother.h"
#include "grafVizStroked.h"
#include "grafTransAverage.h"
#include "guiSlider.h"
#include "guiButton.h"
#include "guiButtonGroup.h"
#include "guiManager.h"

#include <glpfile.h>
#include "gl2ps.h"

/*
Main class to manage the visualizations.
: Loads all tags in the directory
: Plays back each tag with transitions

*/

enum{ MODE_NORM, MODE_TRANS };
enum{ T_AVG };

class grafVisualManager
{
    public:
        grafVisualManager();
        virtual ~grafVisualManager();

        void setup(int sw=1024, int sH=768);
        void setupGuiControls();

        // clears all current tags
        void reset();

        // updates animation and transitions
        void update();

        // draws current visuals to screen
        void draw();
        void displayInfo();
        void displayGui();
        void drawEdgeFade();

        // controls for interface
        void updateGuiDrag( int mx, int my );
        void updateGuiPress( int mx, int my );

        // loads all tags in "data/tags" directory into memory
        void loadTags();

        // advance to next tag
        void nextTag();
        void prevTag();
        void resetTag();

        // for manual adjusting
        void adjustTagPos( int x, int y, int z );
        void adjustTagRot( int x, int y );
        void togglePaused(){ bPaused = !bPaused; }
        void resetRotation();

        // input output
        void saveCurrent();
        void saveScreen();
        void writefile();


        vector<string> dirs;
        grafIO                  * GIO;                  // loads and saves tags
        grafTag                 * GR;                   // holder for current tag while loading
        ofxPocoDirectoryLister  * PL;                   // searches through directories

        // visuals
        grafCurveSmoother       smoother;           // smooths original recorded data clean playback
        grafParticleVecField    * VIZ_PS;           // particle field manager
        grafVizStroked          * VIZ_ST;           // renders the tag as thick line
        grafTransAverage        * TRANS_AVG;        // averages tag data so it appears to blend away during transition

        // time data
        float                   waitTime;           // time (in seconds) to wait before playing transition to next tag
        float                   waitCounter;        // counter to countdown wait time
        float                   lastTime;           // last time of render , for time based animatoin
        float                   dt;                 // time difference from last frame

        // display params
        float                   avgRate;            // rate at which to average tag during transition
        float                   rotation;           // current rotation of the tag
        float                   fadeRate;           // rate at which to fade out the tag during transition

        // tag objects
        vector<grafTag>         myTags;                 // vector of all loaded tags, smoothed
        vector<grafTag>         transTags;              // vector of smoothed tags, used in transitions
        vector<grafTag>         origTags;               // vector of all loaded tags

        int     currentTag;                             // id of current tag on display
        int     w,  h, screenW, screenH;
        int     mode;
        int     trans_mode;
        bool    bPaused;
        bool    bDisplayInfo;
        bool    bPrintfile;
        bool    bDisplayGui;
        bool    bDrawFadeEdges;

    protected:

        bool updateTransition(grafTag * tag);
        void updateRotation(grafTag * tag);


        // gui
        float fogStart, fogEnd, fogBlend;


        guiManager gui;




    private:
};

#endif // GRAFVISUALMANAGER_H
