#ifndef _GRAF_RECORDER_APP
#define _GRAF_RECORDER_APP


#include "ofMain.h"
#include "grafTagMulti.h"
#include "grafIO.h"
#include "grafDrawerRecording.h"
#include "pocoDirectoryLister.h"
#include "ofxControlPanel.h"
#include "ofxXmlSettings.h"
#include "ofThreadedImage.h"
#include "tracker.h"
#include "grafEditor.h"

enum{ REC_CAPTURE, REC_EDIT};

class grafRecorderApp{

	public:

		grafRecorderApp();
		~grafRecorderApp();
		void setup();
		void reset();
		void update();
		
		void draw();
		void drawTracking();
		void drawControls();
	
		void keyPressed  (int key);
		void keyReleased(int key);
		void mouseMoved(int x, int y );
		void mouseDragged(int x, int y, int button);
		void mousePressed(int x, int y, int button);
		void mouseReleased(int x, int y, int button);
		
		void setupContolPanel();
		void updateControlPanel();
		void cropTagToEdits();
		void saveTag();
		void toggleRecording();
	
		
		string getPath(){ if( bUseFolders ) return directory+"/"+tag.tagname+"/"; else return directory+"/"; }
		bool isEditingName(){ return false; }
	
		//----------- video input
		ofBaseVideo     * videoSource;
	
		//---------- tracking
		tracker		grafTracker;
	
		//---------- recorded gml tag
		grafTagMulti tag;						
	
		//----------- edit tag
		grafEditor	 gEditor;
	
		
		//---------- saving tag
		grafIO		gIO;
		string		directory;
		bool		bUseFolders;
	
		//---------- drawing
		grafDrawerRecording			drawer;					// draws thick time stroked line
		ofPoint				tagPosVel;				// vel for moving tag around on screen
		float				tagMoveForce;			// force for moving tag around
		float				dt;
		float				fps, fpsCounter;
		ofTrueTypeFont		fontL;
		
		//---------- application settings
        bool            bShiftOn;
		bool            bUseVideoFiles;
		bool            bUseMouseCapture;
		bool            bShowPanel;
		bool            bShowEditPanel;
		bool            bRecording;
		int             camW,camH,camId;
		int             screenW,screenH;
		float           lastX, lastY;
		int             mouse_mode;
		float			zoom;
		bool			bZooming;
		int				recordMode;
	

		//---------- controls
		ofxControlPanel		panel;

	
};

#endif
