#include "testApp.h"
#include "stdio.h"

//--------------------------------------------------------------
testApp::testApp(){


    screenW = ofGetWidth();
    screenH = ofGetHeight();
    bShowFrameRate = false;
	
	mode = MODE_RECORDER;
	bHomeOn = true;
}

testApp::~testApp(){


}
//--------------------------------------------------------------
void testApp::setup(){


    //-----------
	lastX           = 0;
	lastY           = 0;
	mouse_mode      = 3;
	bShiftOn        = false;
	bMouseOn		= true;

    //-----------
    ofSetFrameRate(60); // to 30 for player
    ofBackground(0.0f, 0.0f, 0.0f);
    ofSetVerticalSync(true);
	
	
	//-----------
	appGrafRecorder.setup();
	appGrafPlayer.setup();
	

}

//--------------------------------------------------------------
void testApp::update(){

    screenW = ofGetWidth();
    screenH = ofGetHeight();

	if( mode == MODE_RECORDER )		appGrafRecorder.update();
	else if( mode == MODE_PLAYER )	appGrafPlayer.update();
	
}


//--------------------------------------------------------------
void testApp::draw(){

	if( mode == MODE_RECORDER )		appGrafRecorder.draw();
	else if( mode == MODE_PLAYER )	appGrafPlayer.draw();
	
}


//--------------------------------------------------------------
void testApp::keyPressed  (int key){

	if( key == OF_KEY_RETURN ) changeMode();
	
	if( mode == MODE_RECORDER ) appGrafRecorder.keyPressed(key);
	
	if( mode == MODE_RECORDER && appGrafRecorder.gEditor.isEnteringName()  ){
		// return because we are editing the name text
		return;
	}
	
	if( mode == MODE_PLAYER )	appGrafPlayer.keyPressed(key);
		
	if( key == 'm')
	{
		if(bMouseOn){
			ofHideCursor();
			bMouseOn = false;
		}
		else{
			ofShowCursor();
			bMouseOn = true;
		}
		
	}
	
	if( key == 'f' ) ofToggleFullscreen();
	
	
	
}

//--------------------------------------------------------------
void testApp::keyReleased(int key){

	if( mode == MODE_RECORDER )		appGrafRecorder.keyReleased(key);
	else if( mode == MODE_PLAYER )	appGrafPlayer.keyReleased(key);
}

//--------------------------------------------------------------
void testApp::mouseMoved(int x, int y ){

	if( mode == MODE_RECORDER )		appGrafRecorder.mouseMoved(x,y);
	else if( mode == MODE_PLAYER )	appGrafPlayer.mouseMoved(x,y);

}

//--------------------------------------------------------------
void testApp::mouseDragged(int x, int y, int button){


	if( mode == MODE_RECORDER )		appGrafRecorder.mouseDragged(x,y,button);	
	else if( mode == MODE_PLAYER )	appGrafPlayer.mouseDragged(x,y,button);
	

}

//--------------------------------------------------------------
void testApp::mousePressed(int x, int y, int button){

    
	if( mode == MODE_RECORDER )		appGrafRecorder.mousePressed(x,y,button);
	else if( mode == MODE_PLAYER )	appGrafPlayer.mousePressed(x,y,button);
		
	if(glutGetModifiers() == GLUT_ACTIVE_SHIFT) bShiftOn = true;
	else bShiftOn = false;
	
	appGrafPlayer.bShiftOn = bShiftOn;
	appGrafRecorder.bShiftOn = bShiftOn;


}

//--------------------------------------------------------------
void testApp::mouseReleased(int x, int y, int button){

	if( mode == MODE_RECORDER )		appGrafRecorder.mouseReleased(x,y,button);
	else if( mode == MODE_PLAYER )	appGrafPlayer.mouseReleased(x,y,button);
	
	bShiftOn = false;

}

//--------------------------------------------------------------
void testApp::resized(int w, int h){

}

//--------------------------------------------------------------
void testApp::changeMode(){
	
	// if in edit mode, change to player
	if( mode == MODE_RECORDER && appGrafRecorder.recordMode == REC_EDIT )
	{
		// save tag to xml
		appGrafRecorder.saveTag();
		appGrafPlayer.loadTag( appGrafRecorder.getPath(), appGrafRecorder.tag.tagname );
		
		// switch to playback
		mode = MODE_PLAYER;
	
	}else if( mode == MODE_PLAYER )
	{
		// reset recorder
		appGrafRecorder.reset();
		
		// switch to recorder
		mode = MODE_RECORDER;
	}else{
		appGrafRecorder.toggleRecording();
	}
	
	
}

