#include "grafIO.h"


grafIO::grafIO()
{
   	uniquID		= "";
	clientname  = "";
	version		= "";
	
	
	
}

grafIO::~grafIO()
{
    //dtor
}


void grafIO::setup(string uId, string client, string vers)
{
	uniquID		= uId;
	clientname  = client;
	version		= vers;
}

void grafIO::addKeyword( string keywd )
{
	if( keywords.size() >  0 )  keywords += ",";
	if( keywd.size() >  0 )		keywords += keywd;
}

void grafIO::clearKeywords()
{
	keywords.clear();
}

void grafIO::constructGML(grafTag * tag)
{
	
	xml.clear();
	
	xml.addTag("GML");
	xml.addAttribute("GML","spec","0.1b",0);

	xml.pushTag("GML");
	//---------------------
	xml.addTag("tag");
	xml.pushTag("tag");
					
		xml.addTag("header");
		xml.pushTag("header");
			
				xml.addTag("client");
				xml.pushTag("client");
					xml.addValue("name", clientname);
					xml.addValue("version", version);
					xml.addValue("username", "dustTag");
					xml.addValue("keywords", keywords);
					xml.addValue("uniqueKey", uniquID);
				xml.popTag();

		xml.popTag();
	
		
	
		xml.addTag("drawing");
		xml.pushTag("drawing");
	
			xml.addTag("stroke");
			xml.pushTag("stroke");
				for( int i = 0; i < tag->getNumPts(); i++)
				{
					xml.addTag("pt");
					xml.pushTag("pt",i);
						xml.setValue("x",tag->pts[i].pos.x);
						xml.setValue("y",tag->pts[i].pos.y);
						xml.setValue("z",tag->pts[i].pos.z);
						xml.setValue("time",tag->pts[i].time);
					xml.popTag();
				}
	
			xml.popTag();
		
	xml.popTag();
	
	xml.popTag();
	//----------------------
	xml.popTag();
}

void grafIO::constructGML(grafTagMulti * tag)
{
	
	xml.clear();
	
	xml.addTag("GML");
	xml.addAttribute("GML","spec","0.1b",0);
	
	xml.pushTag("GML");
	//---------------------
	xml.addTag("tag");
	xml.pushTag("tag");
	
	xml.addTag("header");
	xml.pushTag("header");
		xml.addTag("client");
		xml.pushTag("client");
			xml.setValue("name", clientname);
			xml.setValue("version", version);
			xml.setValue("username", "dustTag");
			xml.setValue("keywords", keywords);
			xml.setValue("uniqueKey", uniquID);
		xml.popTag();
	xml.popTag();
	
	xml.addTag("environment");
	xml.pushTag("environment");
		xml.addTag("up");
		xml.pushTag("up");
			xml.setValue("x", 1);
			xml.setValue("y", 0);
			xml.setValue("z", 0);
		xml.popTag();
	
		xml.addTag("screenBounds");
		xml.pushTag("screenBounds");
			xml.setValue("x", 480);
			xml.setValue("y", 320);
			xml.setValue("z", tag->z_const);
		xml.popTag();
	xml.popTag();
	
	
	
	xml.addTag("drawing");
	xml.pushTag("drawing");
		// strokes
		for(int s = 0; s < tag->myStrokes.size(); s++)
		{
			xml.addTag("stroke");
			xml.pushTag("stroke",s);
			for( int i = 0; i < tag->myStrokes[s].pts.size(); i++)
			{
				xml.addTag("pt");
				xml.pushTag("pt",i);
				xml.setValue("x",tag->myStrokes[s].pts[i].pos.x);
				xml.setValue("y",tag->myStrokes[s].pts[i].pos.y);
				xml.setValue("z",tag->myStrokes[s].pts[i].pos.z);
				xml.setValue("time",tag->myStrokes[s].pts[i].time);
				xml.popTag();
			}
			xml.popTag();
		}
	xml.popTag();
	xml.popTag();
	//----------------------
	xml.popTag();
	
	//string xmlString;
	//xml.copyXmlToString(xmlString);
	//cout << xmlString << endl;
	

}

