#include "grafManager.h"

grafManager::grafManager()
{
	recorder		 = new grafRecorder();
	vizStroke		 = new grafVStroke();
	gui				 = new guiManager();
	guiStart		 = new guiManager();
	guiEdit			 = new guiManager();
	guiView			 = new guiManager();
	
	screenW			= 320;
    screenH			= 480;
	recScale		= 480;
		
	bPlaying		= false;
	bReadyToRecord	= false;
	
	currentTag		= 0;
	rotation		= 0.f;
	
	touch[0].set(0,0);
	touch[1].set(0,0);
	
	touchOn[0]		= false;
	touchOn[1]		= false;
	
	prevDist	= 0.f;
	waitTime    = 2.0f;
    waitCounter = waitTime;
	lastTime    = ofGetElapsedTimef();
	
	avgRate		= .25;
	fadeRate	= 8.f;
	
	mode	= MODE_START_MENU;//MODE_LOAD_MENU;//START_MENU;//MODE_NORM;
	
	franklinBook.loadFont("frabk.ttf",28);
	franklinBookSM.loadFont("frabk.ttf",14);
	franklinBookSSM.loadFont("frabk.ttf",10);
	
	nRecordings = 0;
	bgAlpha = 1.0f;
	pressAgainAlpha = 1.f;
	alphaPause	= 0.f;
	
}
//--------------------------------------------------------------
grafManager::~grafManager()
{
    delete recorder;
	delete vizStroke;
	delete gui;
	delete guiStart;
	delete guiView;
}
//--------------------------------------------------------------
void grafManager::setup()
{
	// initialize the accelerometer
	ofxAccelerometer.setup();
	ofxAccelerometer.setOrientationSmoothing(.95);
	
	// touch events will be sent to myTouchListener
	ofxMultiTouch.addListener(this);
	
	recorder->tag.setDrawScale(recScale);
	recorder->scale = recScale;
	
	setupGuiControls();
	
	bgImage.loadImage("Default.png");
		
}
//--------------------------------------------------------------
void grafManager::reset()
{
  
}
//--------------------------------------------------------------
void grafManager::setupGuiControls()
{
	gui->addDoubleButton( "Record", 10,10,70,70, false, 200, DRAW_RECORD);
	gui->addButton( "Pause Area", screenW/2 - 100, screenH/2 - 100, 200,200, false, 200, DRAW_NONE);
	
	guiStart->addButton( "View", 60, 40, 180, 180, false);
	guiStart->addButton( "Write", 60, 260, 180, 180, false);
	
	guiEdit->addButton( "Edit Name", 73,335,25,100, false,80);
	guiEdit->addButton( "Save", 103,335,25,100, false, 80);
	guiEdit->addButton( "Upload", 133,335,25,100, false, 80);
	guiEdit->addButton( "Close", 193,335,25,100, false, 80);
	
	
	
}
//--------------------------------------------------------------
void grafManager::update()
{
	
	float dt  = ofGetElapsedTimef()-lastTime;
	lastTime  = ofGetElapsedTimef();
	
	if( mode == MODE_START_MENU )
	{
		if( bgAlpha > .1 ) bgAlpha -= dt*.5;
	}
	
	
	//---------- playback
	if( mode == MODE_TRANS || mode == MODE_NORM )
	{
			
		if( alphaPause > 0) alphaPause -= dt*.25f;
		if( bPlaying && nRecordings > 0 && pressAgainAlpha > 0 ) pressAgainAlpha -= dt*.5; ;
		
		if( bPlaying && myTags.size() > 0 && !myTags[ currentTag ].bPaused )
		{
			// calculate time difference
			bool bUpdateParticles = false;
		
			// check current playback state
			// if tag finished drawing, pause
			if( myTags[ currentTag ].bReset )
			{
			
				if( waitCounter <= 0 )  
				{	
					mode = MODE_TRANS; // if pause is done, start transition mode
				}else{
					// if waiting, decrease wait time, cont update particle system, remove arrow
					waitCounter = (waitCounter-dt < 0) ? 0 : waitCounter-dt;
					bUpdateParticles = true;
				}
			
			}else{
           
				myTags[ currentTag ].update();
				if(myTags[ currentTag ].getCurrentId() > 1 && mode != MODE_TRANS) 
					bUpdateParticles = true;
			}
		
			
			if( mode == MODE_TRANS && updateTransitions( &myTags[currentTag],dt) )
			{
				bUpdateParticles = false;
				nextTag();
			}
		
		
		}
	
	
		//---------- zooming
		if( bPlaying &&  myTags.size() > 0 && touchOn[0] && touchOn[1] )
		{
			float dist = (touch[0].x-touch[1].x)*(touch[0].x-touch[1].x)+(touch[0].y-touch[1].y)*(touch[0].y-touch[1].y);
			dist  = sqrt(dist);
			dist /= screenH;
			
			// alter scale
			myTags[currentTag].position.z += dist-prevDist;
			myTags[currentTag].position.z  = MAX(.1,myTags[currentTag].position.z);
			
			prevDist = dist;
		}
		
	}
	
	//cout << "mode " << mode << endl;
	//cout << "readyRecord " << bReadyToRecord << endl;
	//cout << "recording " << recorder->isRecording() << endl;
	//cout << "rec button " << gui->getButtonVal("Record") << endl;

}
//--------------------------------------------------------------
void grafManager::draw()
{
	
	
	ofEnableAlphaBlending();
	
	if( mode == MODE_START_MENU )	
		
		drawStartMenu();

	else if(mode == MODE_REC)
		
		drawRecording();
	
	else if ( mode == MODE_TRANS || mode == MODE_NORM )
		
		drawPlayback();
	
	else if( mode == MODE_LOAD_MENU )
	{
		guiView->draw();
	}
	
	
	
}
//--------------------------------------------------------------
void grafManager::drawRecordButton()
{
	
}
//--------------------------------------------------------------
void grafManager::drawPlayback()
{
	
	
	glPushMatrix();
		
		
	
		//---------- set up draw pos, rot, scale
		// center screen
		glTranslatef(screenW/2, screenH/2, 0);
		
		//glMultMatrixf(ofxAccelerometer.getMatrix());	
		glScalef(myTags[currentTag].position.z,myTags[currentTag].position.z,myTags[currentTag].position.z);
			
		// rotate
		glRotatef(myTags[currentTag].rotation.x,0,1,0);
		glRotatef(myTags[currentTag].rotation.y+(ofxAccelerometer.getOrientation().x*2)+20,1,0,0);
		glRotatef(myTags[currentTag].rotation.z,0,0,1); 
			
		// translate to draw offset
		glTranslatef(myTags[currentTag].position.x,myTags[currentTag].position.y,0);
	
		
		
		//---------- playback
		if( bPlaying )
		{		
			vizStroke->draw(&myTags[ currentTag ],-screenW/2, -screenH/2);
		}
	
	glPopMatrix();
	
	// draw gui
	ofSetColor(0xffffff);
	gui->draw();
	
	if( nRecordings == 1 )
	{
		ofSetColor(255,255,255,255*pressAgainAlpha);
		glPushMatrix();
		
		glTranslatef(screenW/2,screenH/2,0);
		glRotatef(-90, 0, 0, 1);
		glTranslatef(-screenH/2,-screenW/2,0);
		
		franklinBookSSM.drawString("Record Again", 392, 13);
		
		glPopMatrix();
		
		
	}
	
	
	drawPauseButton();
	
	
	
	
}
//--------------------------------------------------------------
void grafManager::drawRecording()
{
	// draw recording line
	glPushMatrix();
	
		glTranslatef(screenW/2, screenH/2, 0);
		recorder->draw(-screenW/2, -screenH/2);
	
	glPopMatrix();
	
	
	// draw gui
	ofSetColor(0xffffff);
	if(nRecordings > 0 ) gui->draw();
}
//--------------------------------------------------------------
void grafManager::drawStartMenu()
{
	/*
	 ofNoFill();
	ofSetColor(255, 255, 255 );
	ofRect( 60, 40, 180, 180 );
	ofRect( 60, 260, 180, 180 );
	
	glPushMatrix();
		glTranslatef(160,405,0);
		glRotatef(-90,0,0,1);
		franklinBook.drawString("WRITE",0,0 );
	glPopMatrix();
	
	glPushMatrix();
		glTranslatef(160,180,0);
		glRotatef(-90,0,0,1);
		franklinBook.drawString("VIEW",0,0 );
	glPopMatrix();
	 */
	
	// draw bg image
	ofSetColor(255,255,255,255*bgAlpha);
	bgImage.draw(0,0);
	
	ofSetColor(255,255,255,255);
	
	// draw Title
	glPushMatrix();
		
			glTranslatef(screenW/2,screenH/2,0);
			glRotatef(-90, 0, 0, 1);
			glTranslatef(-screenH/2,-screenW/2,0);
			franklinBook.drawString("phoneTag v1.0", 60,130);
			franklinBookSM.drawString("Double-Tap to start tagging...", 60,170);
		
	glPopMatrix();
	
	// draw record button
	
}
//--------------------------------------------------------------
void grafManager::drawPauseButton()
{
	if( alphaPause <= 0 ) return;
	
	int hScreenW = screenW/2;
	int hScreenH = screenH/2;
	
	ofSetColor(0,0,0,200*alphaPause);
	ofFill();
	ofRect(hScreenW-100, hScreenH-100, 200, 200);
	
	ofSetColor(80,80,80,200*alphaPause);
	ofNoFill();
	ofRect(hScreenW-100, hScreenH-100, 200, 200);
	
	glPushMatrix();
	
		glTranslatef(screenW/2,screenH/2,0);
		glRotatef(-90, 0, 0, 1);
		glTranslatef(-screenH/2,-screenW/2,0);
		
		ofSetColor(255,255,255,255*alphaPause);
		int strW = franklinBookSM.stringWidth( "Paused" );
		franklinBookSM.drawString( "Paused", hScreenH - strW/2, hScreenW-30 );
		
		int strWS = franklinBookSSM.stringWidth( "Double-tap here to play." );
		franklinBookSSM.drawString( "Double-tap here to play.", screenH/2 - strWS/2, screenW/2 );
		
	glPopMatrix();

	
}
//--------------------------------------------------------------
bool grafManager::updateTransitions( grafTag * tag, float dt )
{
	
	float ddt = dt*(1/16.f);
	bool bDoneWithTag = false;
	
	vizStroke->averagePoints(avgRate);
	vizStroke->alterParam( -(.75*fadeRate) * ddt, vizStroke->alphaStroke);
	
	if( vizStroke->alphaStroke < 1 ){
		vizStroke->alterParam( -(.75*fadeRate) * ddt, vizStroke->alpha);
		if( vizStroke->alpha <= 0 ) bDoneWithTag =  true;
	}
	
	return bDoneWithTag;
}
//--------------------------------------------------------------
/*void grafManager::storeCurrentRecording()
{
	if( recorder->tag.pts.size() == 0 ) return;
	
	grafTag tempTag;
	
	myTags.push_back( tempTag );
	myTags[ myTags.size()-1 ] = recorder->tag;
	myTags[ myTags.size()-1 ].setDrawScale( recScale );
	//myTags[ myTags.size()-1 ].averagePts();
	
	currentTag = myTags.size()-1;
	
	recorder->smooth(&myTags[currentTag]);
	
	myTags[ currentTag ].tagname = io->getTagName( myTags[ currentTag ].tagname );
	
	nRecordings++;
	if(nRecordings==1) gui->setDoubleButton("Record",1);
	//io->saveTag(&myTags[currentTag]);
}*/

//--------------------------------------------------------------
void grafManager::touchDown(float x, float y, int touchId, ofxMultiTouchCustomData *data)
{
	
	printf("grafManager touch %i down at (%.1f,%.1f)\n", touchId, x,y);
	
	if( touchId == 0 )	touchOn[0] = true;
	else				touchOn[1] = true;
	
	if( mode == MODE_START_MENU )
	{
		guiStart->updatePress(x,y);
	}
	else if( mode == MODE_REC || mode == MODE_NORM || mode == MODE_TRANS )
	{	
		
	
		
		// if recording is ready and we touch, start the recording
		if(bReadyToRecord  && gui->getButtonVal("Record") )
		{
			bReadyToRecord = false;
			recorder->startRecording( ofxAccelerometer.getOrientation().x );
			mode = MODE_REC;
			//vizParticleField->reset();
		}
		
		gui->updatePress(x,y);
		
	}else if( mode == MODE_EDIT_TAG )
	{
		guiEdit->updatePress(x,y);
	}
	
	
	if( touchId == 0 )	touch[0].set(x,y);
	else				touch[1].set(x,y);
	
	
	if( touchOn[0] && touchOn[1] )
	{
		float dist = (touch[0].x-touch[1].x)*(touch[0].x-touch[1].x)+(touch[0].y-touch[1].y)*(touch[0].y-touch[1].y);
		dist  = sqrt(dist);
		dist /= screenH;
		prevDist = dist;
	}
	
	
	
	
	
}
//--------------------------------------------------------------
void grafManager::touchMoved(float x, float y, int touchId, ofxMultiTouchCustomData *data)
{
	
	printf("grafManager touch %i moved at (%.1f,%.1f)\n", touchId, x,y);
	
	
	//---------- recording
	if( recorder->isRecording() && touchOn[0] )
	{
		recorder->update(x,y);
	}
	
	//---------- moving position
	else if( bPlaying &&  myTags.size() > 0 && (touchOn[0] && !touchOn[1]) )
	{
		adjustTagPos(x-touch[0].x,y-touch[0].y);
		cout << "adjust pos " << endl;
	}
	
	if( touchId == 0 )	touch[0].set(x,y);
	else				touch[1].set(x,y);
	
	
}
//--------------------------------------------------------------
void grafManager::touchUp(float x, float y, int touchId, ofxMultiTouchCustomData *data)
{
	
	if( touchId == 0 )	touch[0].set(x,y);
	else				touch[1].set(x,y);
	
	if( touchId == 0 )	touchOn[0] = false;
	else				touchOn[1] = false;
	
	if( mode == MODE_START_MENU )
	{
		/*if( guiStart->getButtonVal("Write") )
		{
			mode			= MODE_REC;
			bReadyToRecord	= true;
			gui->setDoubleButton("Record", 1);
			cout << "Touch Up: Ready to record." << endl;
		}
		else if(  guiStart->getButtonVal("View") )
			mode = MODE_LOAD_MENU;*/
	}
	else if( mode == MODE_REC || mode == MODE_NORM || mode == MODE_TRANS )
	{	
		
		if( gui->getButtonVal("Record") && !recorder->isRecording())
		{
			// turn off playing
			bPlaying = false;
				
			// turn on recording
			bReadyToRecord = true;
			
			
						
		}
		
		if( gui->getButtonVal("Edit Tag") )
		{
			//mode = MODE_EDIT_TAG;
			gui->setButton("Edit Tag", false );
		}
		

		if( touchId == 0 && recorder->isRecording() && !bReadyToRecord)
		{
				// stop recording
				recorder->stopRecording();
				
				// rec button should be off
				gui->setButton("Record",false);
			
				// double check last is reset
				if(myTags.size() > 0 ) resetTag();
					
				// store the current drawing
				//storeCurrentRecording();
			
				// set up to go to playback mode
				if(myTags.size() > 0 )
				{
					
					bPlaying		= true;
					waitCounter		= waitTime;		
					
					resetTag();
					
					//vizParticleField->reset();
					vizStroke->reset();
					
					mode = MODE_NORM;
				}else{
				
					mode = MODE_REC;
					
					bPlaying = false;
					
					bReadyToRecord = true;
					
					gui->setButton("Record", true);
					
					cout << "restart recording" << endl;
				}
			
			
		}
		
	}else if( mode == MODE_EDIT_TAG )
	{
		cout << "mode edit tag " << endl;
		
		if( guiEdit->getButtonVal("Upload") && myTags.size() > 0 )
			cout << "upload tag " << endl;
			//uploader->uploadToWeb(myTags[currentTag]);
		else if( guiEdit->getButtonVal("Close") )
		{
			cout << "close edit tag " << endl;
			mode = MODE_NORM;
		}else if(guiEdit->getButtonVal("Save") )
		{
			cout << "save tag " << endl;
			//io->saveTag(&myTags[currentTag],myTags[currentTag].tagname);
		}
		
	}
	

	
	printf("grafManager touch %i up at (%.1f,%.1f)\n", touchId, x,y);
}
//--------------------------------------------------------------
void grafManager::touchDoubleTap(float x, float y, int touchId, ofxMultiTouchCustomData *data){
	
	printf("grafManager touch %i double tap at (%.1f,%.1f)\n", touchId, x,y);
	
	if(myTags.size() > 0 ) gui->updatePressDoubleTap(x,y);
	
	if(bPlaying)
	{
		if( gui->getButtonHitTest( "Pause Area", x,y ) )
			myTags[currentTag].bPaused = !myTags[currentTag].bPaused;
		
		if( myTags[currentTag].bPaused ) alphaPause = 1.f;
	}
	
	if( mode == MODE_START_MENU )
	{
		mode = MODE_REC;
		
		bPlaying = false;
		
		bReadyToRecord = true;
		
		gui->setButton("Record", true);
	}
	
	/*if( !recorder->isRecording() )
	{
		// turn off playing
		bPlaying = false;
		
		// turn on recording
		bReadyToRecord = true;
		
	}*/
}
//--------------------------------------------------------------
void grafManager::adjustTagPos( int x, int y )
{
	if(myTags.size() < currentTag || myTags.size() == 0 ) return;
	
	myTags[currentTag].position.x += x;
	myTags[currentTag].position.y += y;
	
	myTags[currentTag].position.x = MIN( MAX(-160,myTags[currentTag].position.x), 160);
	myTags[currentTag].position.y = MIN( MAX(-220,myTags[currentTag].position.y), 220);
}
//--------------------------------------------------------------
void grafManager::resetTag()
{
	// reset tag to start point
    if(myTags.size() == 0 ) return;	
	
	myTags[currentTag].resetToStart();

}
//--------------------------------------------------------------
void grafManager::nextTag()
{
	resetTag();
	
	myTags[currentTag].bReset    = false;
    waitCounter                  = waitTime;
	
    currentTag++;
    currentTag = currentTag % (int)myTags.size();
	
    resetTag();
	
	//vizParticleField->reset();
    vizStroke->reset();
	
    mode = MODE_NORM;
}