#include "grafRecorder.h"

bool sort_zpos_compare( timePt a, timePt b ) {
	
	return (a.z < b.z);
}

grafRecorder::grafRecorder()
{

	bRecording	= false;
	scale		= 1;
	iniRotation = 0.f;
	
	memset(pos,0,3*MAX_REC_PTS);
	
}

grafRecorder::~grafRecorder()
{
    //dtor
}


void grafRecorder::clear()
{
    
}


void grafRecorder::update(float x, float y)
{
	
	if( tag.getNumPts()-1 >= MAX_REC_PTS ) return;
		
	x /= scale;
	y /= scale;
	
	bool bNewAdded = tag.addNewPoint(ofPoint(x,y), -1, -1, -1, true);
	printf("grafRecorder: new point %i\n", bNewAdded);
	
	if( bNewAdded )
	{
		tag.setCurrentToLast();
		tag.calcMinMax();
		
		pos[ (tag.getNumPts()-1)][0]	= tag.getCurrentPoint().x;
		pos[ (tag.getNumPts()-1)][1]	= tag.getCurrentPoint().y;
		pos[ (tag.getNumPts()-1)][2]	= 0;//(tag.getCurrentTime() * 1000.f ) / tag.z_const;
	}
	
	// shift back so current is always at 0 z depth
	for( int i = 0; i < tag.getNumPts()-1; i++)
	{
		pos[i][2] = 0;//tag.pts[i].z - tag.getCurrentPoint().z;
	}
	
	printf("grafRecorder: update num pts %i last %f, %f \n",tag.getNumPts(),tag.getCurrentPoint().x,tag.getCurrentPoint().y);
    
}

void grafRecorder::startRecording( float rotation )
{
	bRecording = true;
	tag.clear();
	
	printf("grafRecorder: start recording\n");
	//memset(pos,0,3*MAX_REC_PTS);
	
	iniRotation = rotation;
}

void grafRecorder::stopRecording()
{
	bRecording = false;
	printf("grafRecorder: stop recording\n");
}

void grafRecorder::draw(int hScreenW, int hScreenH)
{
	ofSetColor(255,255,255,255);
	
	glPushMatrix();
	
		glTranslatef(hScreenW, hScreenH, 0);
		glScalef(tag.drawScale,tag.drawScale,1);
	
		glEnableClientState(GL_VERTEX_ARRAY);
	
			glVertexPointer(3, GL_FLOAT, 0, pos);
			glDrawArrays( GL_LINE_STRIP, 0,tag.getNumPts()-1 );
	
		glDisableClientState(GL_VERTEX_ARRAY);
	
	
	glPopMatrix();
	
}


void grafRecorder::smooth( grafTag * myTag )
{
	smoother.smoothTag(4, &tag, myTag);
	sort( myTag->pts.begin(), myTag->pts.end(), sort_zpos_compare );
	myTag->calcMinMax();
	myTag->averagePts();
	myTag->averagePts();
	
}


