#include "grafVParticleField.h"

grafVParticleField::grafVParticleField()
{
    
    alpha				= 1;
    particle_damping	= .15f;
    particle_size		= 6.f;
    particle_alpha		= .75f;
}

grafVParticleField::~grafVParticleField()
{
    //dtor
}

void grafVParticleField::reset()
{
	
    // set up original set with lines
    PS.reset(WIDTH_FIELD,HEIGHT_FIELD);
	
    // set up extras for flare
    for( int i = 0; i < XTRA_PS.size(); i++)
        XTRA_PS[i].reset(WIDTH_FIELD,HEIGHT_FIELD);
	
    // set vector field
    VF.bReset = true;
    VF.clearField();
	
    // reset vars
    alpha = 1;
    transitionCounter = 0;
	
}

void grafVParticleField::setup(int w_, int h_)
{
	
    w = w_;
    h = h_;
	
	PS.setup(FIELD_SIZE,WIDTH_FIELD,HEIGHT_FIELD,w,h,&VF);
	
	//particleSystem psx;
	/*int toatlXtra = 1;
	for( int i = 0; i < toatlXtra; i++)
	{
        XTRA_PS.push_back(psx);
        XTRA_PS[i].setup(FIELD_SIZE,WIDTH_FIELD,HEIGHT_FIELD,w,h,&VF);
		
	}*/
	
	setDamping( particle_damping);
	setParticleSize( particle_size );
}

void grafVParticleField::setDamping( float val )
{
	
    particle_damping = val;
    PS.setParticleDropOffRate(particle_damping);
	
    for( int i = 0; i < XTRA_PS.size(); i++) XTRA_PS[i].dropOffRate = (.8*particle_damping) - (i*.01f );
    //setParticleDropOffRate( (.8*particle_damping) - (i*.01f ));
	
}
void grafVParticleField::setParticleSize( float val )
{
	
    particle_size = val;
    PS.setParticleSize(particle_size);
	
    for( int i = 0; i < XTRA_PS.size(); i++) XTRA_PS[i].setParticleSize(particle_size*.75f);
	
}

void grafVParticleField::update( grafTag * PR, ofPoint pointForTime, ofPoint vel, float dt, bool bUpdateVF)
{
	
	
	int currentId	= (PR->getNumPts() > 1 ) ? PR->getCurrentId()-1 : PR->getCurrentId();
    float zdepth	= PR->pts[currentId].z;
	
    PS.update(dt*100,w,h,zdepth, alpha*particle_alpha, PR->bReset);
	
    for( int i = 0; i < XTRA_PS.size(); i++)
		XTRA_PS[i].update(dt*100,w,h,zdepth, alpha);
	
    VF.fadeField(0.99f);//*(dt*100));
	
	vel.x = dt;
	if(!PR->bReset)
		VF.update( pointForTime, vel, h, w, h);
	
	
}

void grafVParticleField::draw( grafTag * PR, int screenW, int screenH )
{
	
	
    int currentId = PR->getCurrentId();
    float zdepth = PR->pts[currentId].z;
	
    ofNoFill();
	
    glPushMatrix();
	
	glTranslatef(-screenW/2, -screenH/2, 0);
	for( int i = 0; i < XTRA_PS.size(); i++)
	{
		XTRA_PS[i].draw(zdepth, alpha*particle_alpha, particle_size*.75f, false );
	}
	
	PS.draw(  zdepth, alpha*particle_alpha, particle_size );
	
	
    glPopMatrix();
	
	
	
}