#ifndef GRAFVIZSTROKE_H
#define GRAFVIZSTROKE_H

#include "ofMain.h"
#include "grafTag.h"

class grafVStroke
{
    public:
        grafVStroke();
        virtual ~grafVStroke();

        void reset();


        void draw( grafTag * PR, int hScreenW, int hScreenH);
        void drawWireframe( grafTag * PR );
        void drawTimeStroke( grafTag * PR );
        void drawTimeLine( grafTag * PR );

        void alterParam( float val, float & param );
        void averagePoints(float pct);

		void calculateStroke( grafTag * PR );
		
		float alpha;
		float alphaWireFrame;
        float alphaStroke;
        float alphaStrokeOutline;
        float fadeLineWidth;

        float strokeBaseAlpha;
        float strokeBaseVal;
        float outlineBaseVal;
        float outlineBaseThick;
        float sclLineSlim;
        float sclLineFat;
        bool bUseSlimMode;


    protected:

        void drawFatLine(grafTag * PR, vector<ofPoint>&left,vector<ofPoint>&right, float grayVal, float aplha, bool bUseDrawShape=false, bool bUseLines = false);
        void drawFatOutline(grafTag * PR, vector<ofPoint>&left,vector<ofPoint>&right);

       
        void calculatePoint(timePt pt, float time_num, float dist, float angle, vector<ofPoint>&left, vector<ofPoint>&right);

        float getAlphaForLinePosition( int pos, int total );

        // fast as thick points
        vector<ofPoint> leftPts;                // pts to make drawing of tangent lines faster
        vector<ofPoint> rightPts;

        // fast as slim points
        vector<ofPoint> leftPtsInv;              // pts to make drawing of tangent lines faster
        vector<ofPoint> rightPtsInv;

        vector<float> distSlim;

        bool bSwap;
        bool bUseAlphaMode;

    private:
};

#endif // grafVStroke_H
