#include "guiDustButton.h"

guiDustButton::guiDustButton()
{
    hitBox = ofRectangle(0,0,10,10);
    bOn = false;
	fade = 0;
	bShowState = false;
	fadeRate = .075f;
}

guiDustButton::~guiDustButton()
{
    //dtor
}

void guiDustButton::setup(  string myname, int x, int y, int w, int h,  int xB, int yB, int wB, int hB, bool bInitOn  )
{
	setup( myname, myname, x,y,w,h,xB,yB,wB,hB,bInitOn);
}

void guiDustButton::setup(  string myname, string xname, int x, int y, int w, int h,  int xB, int yB, int wB, int hB, bool bInitOn )
{
	name	= myname;
	onName	= xname;
	
	hitBox	= ofRectangle(x,y,w,h);
	drawBox = ofRectangle(xB,yB,wB,hB);
	bOn = bInitOn;
	
}


void guiDustButton::update()
{
    if( fade > 0 ) fade -= fadeRate;
	
}

bool guiDustButton::hitTest(int x, int y, bool bSwitched)
{
    if( fade > 0 ) return false;
	
	if( pointInRectangle( hitBox,x,y) )
    {
        if(bSwitched) bOn = !bOn;
		fade = 1;
		return true;
    }
	
    return false;
	
	
}

void guiDustButton::draw()
{
	ofRect( drawBox.x, drawBox.y, drawBox.width,  drawBox.height );
}

void guiDustButton::drawName( ofTrueTypeFont * font, float x, float y,bool bCenterText)
{

	if( bUseChangeName && bOn)
	{
		float wd = 	font->stringWidth( onName );
		if(bCenterText) font->drawString(onName, drawBox.x+( (drawBox.width-wd)*.5 + x ),drawBox.y + y);
		else font->drawString(onName, drawBox.x+x ,drawBox.y + y);
	}
	else
	{
		float wd = 	font->stringWidth( name );
		if(bCenterText) font->drawString(name, drawBox.x+( (drawBox.width-wd)*.5 + x ),drawBox.y + y);
		else font->drawString(name, drawBox.x+x,drawBox.y + y);
	}
	
}