#ifndef GUIMENU_H
#define GUIMENU_H

#include "ofMain.h"
#include "guiUtils.h"
#include "guiDustButton.h"
#include "ofxVectorMath.h"
#include "ofxiPhoneKeyboard.h"

class guiMenu
{
    public:
        guiMenu();
        virtual ~guiMenu();

        void setup( ofPoint pos, int w, int h );
        void draw();
		void update(float dt = .1);
	
		string hitTest( int x, int y );
		void closeOptionsMenu();
		bool isActive( string butonName );
		void switchButton( string buttonName, bool bVal );
		guiDustButton * getButton( string name );
		
		// main menu
		vector<guiDustButton> buttons;
		vector<string> names;
		vector<string> xnames;
		
		ofPoint		pos;
		ofPoint		dst;
		float		mainAlpha;
		float		mainAlphaTime;
	
		// options panel
		bool bOptionsOn;
		guiDustButton	optionsPanel;
		vector<guiDustButton> opbuttons;
		vector<string> opnames;
	
		guiDustButton	opXButton;
		ofImage			xImage;
		
		guiDustButton	opSendButton;
		guiDustButton	opCreditsButton;
	
	
		ofPoint		oppos;
		ofPoint		opdst;
		float		opmainAlpha;
		float		opAlphaTime, opAlphaDst;
	
	
	
		int screenW,screenH;
		ofTrueTypeFont HelveticaN;
		ofTrueTypeFont fontOp;
		ofTrueTypeFont Gara;
		float btW, obtW;
	
		ofxiPhoneKeyboard	* keyboard;
		string keywords;
		bool bHideKeyword;
	
		string uniqueID;
	
	
    protected:
    private:
};

#endif // 
