﻿package com.manolis.utils
{

	import flash.geom.Point;
	
	import com.manolis.math.xMath;
	
	public class DataExtract
	{

		public static function array(o:Object,key:String):Array
		{
			var extract:Array = new Array();

			for each (var newO in o)
			{
				extract.push(newO[key]);
				//trace(newO[key]);
			}
			return extract;
		}
		
		public static function xyzPerc(o:Object):Array
		{
			var extract:Array = new Array(new Array(),new Array(),new Array());

			for each(var key in o)
			{
				extract[0].push(key.x[0].nodeValue);
				extract[1].push(key.y[0].nodeValue);
				extract[2].push(key.time[0].nodeValue);
				
			}
			
			return extract;

		}
		
		public static function xyzArray(o:Object, stageW:Number, stageH:Number):Array
		{
			var extract:Array = new Array(new Array(),new Array());

			for each(var key in o)
			{
				extract[0].push(new Point(key.x[0].nodeValue * stageW,key.y[0].nodeValue * stageH));
				extract[1].push(key.time[0].nodeValue);
			}
			
			return extract;

		}
		
		// CALCULATE THE OFFSET POINTS FROM THE INITIAL COORDINATES
		
		public static function calculateNewCoor(coor:Array, time:Array, markerWeight:Number):Array
		{
			var newCoor:Array = new Array();
			var pts1:Array = new Array();			
			var pts2:Array = new Array();
			

			// THIS CONDITION CHECKS IF THERE ARE ENOUGH POINTS TO CLOSE THE LOOP
			if(xMath.checkForDecimal((coor.length - 3)/2))
			{
				coor[coor.length-2] = coor[coor.length -1 ];
				coor.splice(coor.length-1);
			}
			
			for(var key in coor)
			{
				if(key != 0 && key != coor.length - 1) newCoor.push(findCoor(coor[key-1], coor[key], coor[key+1], markerWeight));
				else newCoor.push(new Array(coor[key], coor[key]));
				
				pts1.push(newCoor[key][0]);
				pts2.push(newCoor[key][1]);
				
			
			}
			
			return [pts1, pts2];
		}
		
        private static function getNorm( a:Object, b:Object ):Point
		{
			if (a == null || b == null) return null;
			var ret:Point = new Point( b.y - a.y, -(b.x - a.x) );
			ret.normalize( 1 );
			return ret;
		}		
		
		
		private static function findCoor(_pt1:Point, _pt2:Point, _pt3:Point, _offset:Number):Array
		{
			var pt1:Object    = _pt1;
			var pt2:Object    = _pt2;
			var pt3:Object    = _pt3;
			var n1:Point;
			var n3:Point;
			var npa:Point;
			var npb:Point;
			var p1:Point      = new Point();
			var p2:Point      = new Point();

			var offset:Number = _offset ;
			
			n1                = getNorm( pt1, pt2 );
			n3                = getNorm( pt2, pt3 );

			// set normal points, also the control points.
			// a = left
			// b = right

			if (n1 == null || n3 == null) npa = (n1) ? n1 : n3;
			else
			{
				npa = n1.add( n3 );
				npa.normalize( 1 );
			}

			n1                = getNorm( pt2, pt1 );
			n3                = getNorm( pt3, pt2 );

			if (n1 == null || n3 == null) npb = (n1) ? n1 : n3;
			else
			{
				npb = n1.add( n3 );
				npb.normalize( 1 );
			}

			p1.x = npa.x * offset + pt2.x;
			p1.y = npa.y * offset + pt2.y;

			p2.x = npb.x * offset + pt2.x;
			p2.y = npb.y * offset + pt2.y;
			
			return new Array(p1, p2);
		}		
	}
}