#include "grafIO.h"

#ifdef TARGET_OSX
	#include <sys/stat.h>
#endif

grafIO::grafIO()
{
    
	count = 0;
	
	
}

grafIO::~grafIO()
{
    //dtor
}

void grafIO::saveTag( string name, ofPoint pos, ofPoint rot, vector<timePt> pts, int start, int end, bool bUseDir  )
{
	constructGML( name, pos, rot, pts,  start,  end );
	if(bUseDir)     mkdir(ofToDataPath("tags/"+name).c_str(),0777);

	if( !bUseDir )	xml.saveFile(name+".gml");
	else			xml.saveFile("tags/"+name+"/"+name+".gml");
}	

void grafIO::saveTag(grafTag * tag)
{
	// check if file already exists
	string sec		= "_" + ofToString( ofGetSeconds() );
	string min		= "_" + ofToString( ofGetMinutes() );
	string hour		= "_" + ofToString( ofGetHours() );
	string day		= "_" + ofToString( ofGetDay() );
	string month	= "_" + ofToString( ofGetMonth() );
	string year		= "_" + ofToString( ofGetYear() );
	
	saveTag(tag,"tempt"+year+month+day+hour+min+sec+".gml");
}

void grafIO::saveTagPreservePts(grafTag * tag, string filename)
{
	constructGML(tag,true);
	xml.saveFile(filename);
}

void grafIO::saveTag(grafTag * tag, string filename)
{
	
	constructGML(tag);
	xml.saveFile(filename);
	
	
}

void grafIO::constructGML(grafTag * tag, bool bUseOrig )
{
	
	
	xml.clear();
	
	xml.addTag("GML");
	//xml.addAttribute("GML","spec","0.1b",0);

	xml.pushTag("GML");
	//---------------------
	xml.addTag("tag");
	xml.pushTag("tag");
			
		
		xml.addTag("header");
		xml.pushTag("header");
			
				xml.addTag("client");
				xml.addValue("client:name", "tempt");
	
		xml.popTag();
	
		xml.addTag("environment");
		xml.pushTag("environment");
		
			xml.addTag("offset");
			xml.pushTag("offset");
				 xml.addValue("x",tag->position.x );
				 xml.addValue("y",tag->position.y);
				 xml.addValue("z",tag->position.z);
			xml.popTag();
		
		
			xml.addTag("rotation");
			xml.pushTag("rotation");
				 xml.addValue("x",tag->rotation.x);
				 xml.addValue("y",tag->rotation.y);
				 xml.addValue("z",tag->rotation.z);
			xml.popTag();
		
		xml.popTag();
	
		xml.addTag("drawing");
		xml.pushTag("drawing");
	
			xml.addTag("stroke");
			xml.pushTag("stroke");
				for( int i = 0; i < tag->getNumPts(); i++)
				{
					xml.addTag("pt");
					xml.pushTag("pt",i);
						if( bUseOrig )
						{
							xml.setValue("x",tag->pts_orig[i].pos.x);
							xml.setValue("y",tag->pts_orig[i].pos.y);
							xml.setValue("z",tag->pts_orig[i].pos.z);
							xml.setValue("time",tag->pts_orig[i].time);
						}
						else{
							xml.setValue("x",tag->pts[i].pos.x);
							xml.setValue("y",tag->pts[i].pos.y);
							xml.setValue("z",tag->pts[i].pos.z);
							xml.setValue("time",tag->pts[i].time);
						}
					xml.popTag();
				}
	
			xml.popTag();
		
	xml.popTag();
	
	xml.popTag();
	//----------------------
	xml.popTag();
}


void grafIO::constructGML( string name, ofPoint position, ofPoint rotation, vector<timePt> pts, int start, int end  )
{
	
	cout << "gml save pts " << pts.size() << endl;
	
	xml.clear();
	
	xml.addTag("GML");
	//xml.addAttribute("GML","spec","0.1b",0);
	
	xml.pushTag("GML");
	//---------------------
	xml.addTag("tag");
	xml.pushTag("tag");
	
	
	xml.addTag("header");
	xml.pushTag("header");
	
	xml.addTag("client");
	xml.addValue("name", name);
	
	xml.popTag();
	
	xml.addTag("environment");
	xml.pushTag("environment");
	
	xml.addTag("offset");
	xml.pushTag("offset");
	xml.addValue("x",position.x );
	xml.addValue("y",position.y);
	xml.addValue("z",position.z);
	xml.popTag();
	
	
	xml.addTag("rotation");
	xml.pushTag("rotation");
	xml.addValue("x",rotation.x);
	xml.addValue("y",rotation.y);
	xml.addValue("z",rotation.z);
	xml.popTag();
	
	xml.popTag();
	
	xml.addTag("drawing");
	xml.pushTag("drawing");
	
	xml.addTag("stroke");
	xml.pushTag("stroke");
	
	int total = end-start;
	for( int i = 0; i < total; i++)
	{
		xml.addTag("pt");
		xml.pushTag("pt",i);
		
		xml.setValue("x",pts[i+start].pos.x);
		xml.setValue("y",pts[i+start].pos.y);
		xml.setValue("z",pts[i+start].pos.z);
		xml.setValue("time",pts[i+start].time);
		
		xml.popTag();
	}
	
	xml.popTag();
	
	xml.popTag();
	
	xml.popTag();
	//----------------------
	xml.popTag();
}


void grafIO::loadSavedTag(grafTag * tag, string filename)
{
	cout << "loading file " << filename << endl;
	
	xml.clear();
	
	if( xml.loadFile(filename) ) cout << "loaded!" << endl;
	
	xml.pushTag("GML");
	//-----------------
		xml.pushTag("tag");
			
		if(xml.pushTag("environment"))
		{
			
			xml.pushTag("offset");
				tag->position.x = xml.getValue("x",0.f);
				tag->position.y = xml.getValue("y",0.f);
				tag->position.z = xml.getValue("z",0.f);
			xml.popTag();
			
			
			xml.pushTag("rotation");
				tag->rotation.x = xml.getValue("x",0.f);
				tag->rotation.y = xml.getValue("y",0.f);
				tag->rotation.z = xml.getValue("z",0.f);
			xml.popTag();
	
		xml.popTag();
		}
	
		xml.pushTag("drawing");
				
				xml.pushTag("stroke");
				
				int numPts = xml.getNumTags("pt");
				cout << "tag n pts " << numPts << endl;
				for( int i = 0; i < numPts-1; i++)
				{
					xml.pushTag("pt",i);
					
						float x = xml.getValue("x",0.f);
						float y = xml.getValue("y",0.f);
						float z = xml.getValue("z",0.f);
						float t = xml.getValue("time",0.f);
					
						bool bnewpt = tag->addNewPoint(ofPoint(x,y,z), -1, -1, t, false);
						cout << x << " " << y << " " << z << " new point " << bnewpt << endl;
					
					xml.popTag();
				}
	
				xml.popTag();
	
			xml.popTag();
	
		xml.popTag();
	//-----------------
	xml.popTag();
	
	cout << "tag pts " << tag->pts.size() << endl;

}

void grafIO::saveGrafTag( string directory, gRecorder * src )
{
	
    cout << directory << endl;
	
    mkdir(ofToDataPath("tags/"+directory).c_str(),0777);
	
    ofxXmlSettings xml;
	
    xml.addTag("data");
    xml.pushTag("data",0);
	xml.setValue("position:x", src->position.x );
	xml.setValue("position:y", src->position.y );
	xml.setValue("position:z", src->position.z );
	
	xml.setValue("rotation:x", src->rotation.x );
	xml.setValue("rotation:y", src->rotation.y );
	xml.setValue("rotation:z", src->rotation.z );
	
	xml.setValue("z_const", src->z_const );
    xml.popTag();
	
    xml.addTag("recording");
    xml.pushTag("recording",0);
	
    int start   = src->getStartPt();
    int end     = src->getEndPt();
	
	
    for( int i=start; i<end; i++)
    {
        xml.addTag("pt");
        xml.pushTag("pt",i-start);
        xml.setValue("x",src->pts[i].pos.x);
        xml.setValue("y",src->pts[i].pos.y);
        xml.setValue("time",src->pts[i].time);
        xml.setValue("angle",src->angles[i]);
        xml.setValue("dist",src->dists[i]);
        xml.popTag();
		
    }
	
    xml.popTag();
	
    string xmlfile = "tags/"+directory + "/" + directory + ".graf";
    xml.saveFile( xmlfile );
	
    // save thumbnail
    ofImage * thumbnail = new ofImage();//ofGetWidth(),ofGetHeight());
    thumbnail->grabScreen(0,0,ofGetWidth(),ofGetHeight());
    thumbnail->saveImage( "tags/"+directory+"/"+directory+".jpg" );
    thumbnail->resize(160,120);
    thumbnail->saveImage( "tags/"+directory+"/"+directory+"_thumbnail.jpg" );
	
    delete thumbnail;
}
