#ifndef GRAFTAG_H
#define GRAFTAG_H

#include "ofMain.h"
#include "ofxVectorMath.h"
#include "grafTypes.h"

class grafTag
{
    public:
        grafTag();
        virtual ~grafTag();

        grafTag(  const grafTag &  mom );


        // clears all point arrays
        void clear();

        // updates the current position in the pts vector based on the current time
        void update();
	
		// updates when recorded
		void setCurrentToLast();
		
		void setDrawScale( float val ){ drawScale = val; }

        // create a new point and add to end of pts vector -- use this for loading tags (following for recording)
        // pt     -normalized position of new point
        // dist   -distance of this point to last (used for line width calculations). If valuse = -1 it will calculate distance from previous point
        // angle  -angle of this point to last. If value = -1 it will calculate to previous
        // time   -time stamp associated with this new point. If value = -1, time is based on elapsedTime - startTime
        bool addNewPoint(ofPoint pt, float dist = -1, float angle = -1, float time = -1, bool bAverage = true);
		
		// set the current point to be the ending of the stroke
		void closeStroke();
	
        // resets tag to first point
        void resetToStart();

        // calculates the min and max distance between points for this tag
        void calcMinMax();

        // averages to smooth out
        void averagePts();

        // get data
        ofPoint getPointForTime(float time, int & whatPointAmI, float & dist, float & angle);
        ofPoint getPointForTime(float time);
        ofPoint getVelocityForTime(float time);
        ofPoint getCurrentPoint();
        float   getDuration();
        float   getCurentZDepth();
        float   getPctDone();
        float   getCurrentTime(){	return timeInRange;  }
        float   getCurrentAngle(){	return nowAngle;	 }
		float   getCurrentDist(){	return nowDist;		 }
        float   getTimeCounter(){	return timeCounter;  }
        int     getCurrentId(){		return nowIndex;     }
        int     getNumPts(){		return pts.size();   }
        int     getStartPt(){		return ptStart;		 }
        int     getEndPt(){			return ptEnd;		 }


		vector <timePt>		pts;            // al points in tag
		vector <timePt>		pts_orig;       // all original points in tag
		map<int, bool>		stroke_ends;	// record end of each stroke

		bool                bPaused;
		bool                bReset;

		ofPoint             rotation;
		ofPoint             position;
		float               z_const;
		float				drawScale;

		ofPoint             min,max;
		float               distMin, distMax;
		float				minPtDist;
		
		string				tagname;
	
    protected:

        float				startTime;
		int					maxNumPts;
		int                 ptStart, ptEnd;             // start and end points. if not edited ptStart = 0 and ptEnd = lastPoint

        float               timeCounter;                // time change for playback
        float               timeOfLastFrame;            // records last time to calc time change
        float               timeInRange;                // current time in the drawing

		int                 nowIndex;                   // last point recorder or last point to be drawn
        float               nowDist;                    // time interpolated distance
        float               nowAngle;                   // time interpolated angle
        ofPoint             nowPointForTime;            // time interpolated point
		int					prevId;

        bool                bPlayed;



    private:
};

#endif // GRAFTAG_H
