#include "guiDoubleButton.h"

guiDoubleButton::guiDoubleButton()
{
    hitBox = ofRectangle(0,0,10,10);
    bOn = false;
	clicks = 0;
	type = BUTTON_DOUBLE;
}

guiDoubleButton::~guiDoubleButton()
{
    //dtor
}

void guiDoubleButton::reset( bool bVal )
{
	bOn = bVal;
	if( bOn ) clicks = 2;
	else clicks = 0;
	
}

bool guiDoubleButton::update(int x, int y)
{
    cout << "double update" << endl;
	
	if( pointInRectangle( hitBox,x,y) )
    {
        clicks++;
		if(clicks >= 2 )
		{
			bOn = true;
			return true;
		}else return false;
    }
    else{
		clicks = 0;
		bOn = false;
		return false;
	}


}

void guiDoubleButton::draw()
{

	switch( drawMode )
	{
		case DRAW_NORM:
			
			if( clicks > 0 )
			{
				if( bOn){ 
					ofFill();
					ofSetColor(150,150,150);
				}else{
					ofNoFill();
					ofSetColor(255,255,255);
				}
				
				ofRect( hitBox.x,hitBox.y,hitBox.width, hitBox.height);
				ofDrawBitmapString(name, hitBox.x+hitBox.width+3, hitBox.y+10);
			}
			break;
			
		case DRAW_RECORD:
			
			if( clicks > 0 )
			{
				ofNoFill();
				if( value >= 0 ) ofSetColor(value,value,value);
				else ofSetColor(255,255,255);
					
				ofCircle( hitBox.x+hitBox.width*.5,hitBox.y+hitBox.width*.5,hitBox.width*.35);
			
				if(bOn ) ofFill();
				ofSetColor(255,0,0);
			
				ofCircle(hitBox.x+hitBox.width*.5,hitBox.y+hitBox.width*.5, hitBox.width*.1);
			}
			
			break;
	}
}
