#include "guiManager.h"

guiManager::guiManager()
{
    //ctor
}

guiManager::~guiManager()
{
    //dtor
}

void guiManager::draw()
{
    for( int i = 0 ; i < sliders.size(); i++)
        sliders[i].draw();

    for( int i = 0; i < buttons.size(); i++)
        buttons[i].draw();
	
	for( int i = 0; i < dbuttons.size(); i++)
        dbuttons[i].draw();
	
	for( int i = 0; i < scrollers.size(); i++)
        scrollers[i].draw();
}

//----------------------------------------------------------------------
void guiManager::addSlider( string name, float defVal, float min, float max, float x, float y, float w, float h)
{
    guiSlider sliderNew;
    sliders.push_back(sliderNew);
    sliders[ sliders.size()-1 ].setup(name,defVal,min,max,x,y,w,h);
}

void guiManager::addButton( string name, float x, float y, float w, float h, bool bOnOff, int val, int drawMode)
{
    guiButton newButton;
    buttons.push_back(newButton);
    buttons[ buttons.size()-1 ].setup( name, x,y,w,h,bOnOff,val);
	buttons[ buttons.size()-1 ].drawMode = drawMode;

}

void guiManager::addDoubleButton( string name, float x, float y, float w, float h, bool bOnOff, int val, int drawMode)
{
	guiDoubleButton newButton;
    dbuttons.push_back(newButton);
    dbuttons[ dbuttons.size()-1 ].setup( name, x,y,w,h,bOnOff,val);
	dbuttons[ dbuttons.size()-1 ].drawMode = drawMode;
	
}

void  guiManager::addScroller( string name, int x, int y, int w, int h, int font_size, bool bVertical )
{
	guiScroller tempscroll;
	scrollers.push_back( tempscroll);
	scrollers[ scrollers.size()-1 ].setup( name, x, y, w, h, font_size,  bVertical );
}

void  guiManager::addToScrollList( string scrollerName, vector<string> names)
{
	for( int i = 0; i < scrollers.size(); i++ )
	{
		if( scrollers[i].name == scrollerName )
		{
			for( int j = 0; j < names.size(); j++)
				scrollers[i].addToList(names[j]);
			
			return;
		}
		
	}
	
}

void  guiManager::addToScrollList( string scrollerName, string name)
{
	for( int i = 0; i < scrollers.size(); i++ )
	{
		if( scrollers[i].name == scrollerName )
		{
			scrollers[i].addToList(name);
			return;
		}
		
	}
}

//----------------------------------------------------------------------
void guiManager::update(float dt)
{
	for( int i = 0; i < scrollers.size(); i++ )
	{
		scrollers[i].update(dt);
	}
	
}

bool guiManager::updateDrag( float mx, float my )
{
    for( int i = 0 ; i < sliders.size(); i++)
    {
        if( sliders[i].update(mx,my) ){
            saveDataToXML();
            return true;
        }
    }

	return false;
}

bool guiManager::updatePress( float mx, float my )
{

    for( int i = 0; i < buttons.size(); i++)
    {
         if( buttons[i].update(mx,my) )
         {
             saveDataToXML();
             return true;
		 }
    }
	
	for( int i = 0; i < dbuttons.size(); i++)
    {
		if( dbuttons[i].update(mx,my) )
		{
			saveDataToXML();
			return true;
		}
    }

	return false;
}

bool guiManager::updatePressDoubleTap( float mx, float my )
{
	
   for( int i = 0; i < dbuttons.size(); i++)
    {
		dbuttons[i].update(mx,my);
		if( dbuttons[i].update(mx,my) )
		{
			saveDataToXML();
			return true;
		}
    }
	
	return false;
}
float guiManager::getFloatVal( string name )
{
    for( int i = 0 ; i < sliders.size(); i++)
    {
        if( sliders[i].getName() == name ) return sliders[i].getFloatValue();
    }
    return 0;
}

int guiManager::getIntVal( string name )
{
    for( int i = 0 ; i < sliders.size(); i++)
    {
        if( sliders[i].getName() == name ) return sliders[i].getIntValue();
    }

    return 0;
}

float guiManager::getPctVal( string name )
{
   for( int i = 0 ; i < sliders.size(); i++)
    {
        if( sliders[i].getName() == name ) return sliders[i].getPctValue();
    }

    return 0;
}

bool guiManager::getButtonVal( string name )
{
    for( int i = 0 ; i < buttons.size(); i++)
    {
        if( buttons[i].name == name ) return buttons[i].bOn;
    }
	
	for( int i = 0 ; i < dbuttons.size(); i++)
    {
        if( dbuttons[i].name == name ) return dbuttons[i].bOn;
    }

    return false;
}

bool guiManager::getButtonHitTest( string name, int x, int y )
{ 
	
	for( int i = 0 ; i < buttons.size(); i++)
	{
		if( buttons[i].name == name ) return buttons[i].hitTest(x,y);
	}
	
	for( int i = 0 ; i < dbuttons.size(); i++)
    {
        if( dbuttons[i].name == name ) return dbuttons[i].hitTest(x,y);
    }
	
    return false;
}

void guiManager::setButton( string name, bool val )
{
    for( int i = 0 ; i < buttons.size(); i++)
    {
        if( buttons[i].name == name ){
			buttons[i].bOn = false;
			return;
		}
    }
	
	for( int i = 0 ; i < dbuttons.size(); i++)
    {
        if( dbuttons[i].name == name ){
			dbuttons[i].reset(val);
			return;
		}
    }
	
}

void guiManager::setDoubleButton(  string name, int clicks )
{
	for( int i = 0 ; i < dbuttons.size(); i++)
    {
        if( dbuttons[i].name == name ){
			dbuttons[i].clicks = clicks;
			if( clicks < 2 ) dbuttons[i].bOn = false;
			return;
		}
    }
}


void guiManager::saveDataToXML()
{
	ofxXmlSettings xml;
	for( int i = 0 ; i < sliders.size(); i++)
    {
        string name = sliders[i].getName();
        int index = name.find_first_of(" ");
        while( (index=name.find_first_of(" ") ) > 0 )
        {
            name.erase(name.begin()+index);
        }

        xml.setValue(name,sliders[i].getFloatValue(),0.f );

    }

    for( int i = 0 ; i < buttons.size(); i++)
    {
        string name = buttons[i].name;
        int index = name.find_first_of(" ");
        while( (index=name.find_first_of(" ") ) > 0 )
        {
            name.erase(name.begin()+index);
        }

        xml.setValue(name,buttons[i].bOn,false );

    }
	
	for( int i = 0 ; i < dbuttons.size(); i++)
    {
        string name = dbuttons[i].name;
        int index = name.find_first_of(" ");
        while( (index=name.find_first_of(" ") ) > 0 )
        {
            name.erase(name.begin()+index);
        }
		
        xml.setValue(name,dbuttons[i].bOn,false );
		
    }

   xml.saveFile("settings/gui.xml");


}

void guiManager::loadDataFromXML()
{
	ofxXmlSettings xml;
	xml.loadFile("settings/gui.xml");

	for( int i = 0 ; i < sliders.size(); i++)
    {
        string name = sliders[i].getName();
        int index = name.find_first_of(" ");
        while( (index=name.find_first_of(" ") ) > 0 )
        {
            name.erase(name.begin()+index);
        }

        sliders[i].setValue( xml.getValue(name,0.f ) );

    }

    for( int i = 0 ; i < buttons.size(); i++)
    {
        string name = buttons[i].name;
        int index = name.find_first_of(" ");
        while( (index=name.find_first_of(" ") ) > 0 )
        {
            name.erase(name.begin()+index);
        }

        buttons[i].bOn =  xml.getValue(name,false );

    }
	
	for( int i = 0 ; i < dbuttons.size(); i++)
    {
        string name = dbuttons[i].name;
        int index = name.find_first_of(" ");
        while( (index=name.find_first_of(" ") ) > 0 )
        {
            name.erase(name.begin()+index);
        }
		
        dbuttons[i].bOn =  xml.getValue(name,false );
		
    }

   xml.saveFile("settings/gui.xml");


}
