#include "testApp.h"

//--------------------------------------------------------------
void testApp::setup(){
	
	ofSetLogLevel(OF_LOG_VERBOSE);
	ofSetFrameRate(30);
	
	bShiftOn = false;
	
	grafMan.setup();
	//grafMan.loadAllSavedTags("tags", false);
	
	
	recMan.setup();
	
	mode = COMBO_REC;
	
	//grafMan.loadTag("grafHK");
	//mode = COMBO_PLAY;
	
}

//--------------------------------------------------------------
void testApp::update(){
	
	if( mode == COMBO_PLAY)		grafMan.update();
	else if( mode == COMBO_REC) recMan.update();
	
	//cout << "pts rec " << recMan.PR->pts.size() << endl;
	
}


//--------------------------------------------------------------
void testApp::draw(){
	
	ofBackground(0,0,0);
	if( mode == COMBO_PLAY)			grafMan.draw();
	else if( mode == COMBO_REC)		recMan.draw();
	else if( mode == COMBO_EDIT)	recMan.draw();
}

void testApp::setToEdit()
{
	if( recMan.PR->pts.size() > 0 )
	{
		recMan.PR->toggleEditing(true);
		recMan.bShowEditPanel = true;
		recMan.bShowCVPanel = false;
		recMan.update();
		mode = COMBO_EDIT;
	}
}

void testApp::setToPlay()
{
	// save file
	cout << "total pts " << recMan.PR->getNumPts() << endl;
	
	recMan.DM->saveTag( "grafHK", recMan.PR->position, recMan.PR->rotation, recMan.PR->pts, recMan.PR->getStartPt(),recMan.PR->getEndPt() );
	recMan.DM->saveTag( recMan.GE->getName(), recMan.PR->position, recMan.PR->rotation, recMan.PR->pts, recMan.PR->getStartPt(),recMan.PR->getEndPt(),true );
	recMan.DM->saveGrafTag(recMan.GE->getName(), recMan.PR);
	recMan.GE->setDefaultName( "graf" );
	// load file
	grafMan.loadTag("grafHK");
	mode = COMBO_PLAY;
}

void testApp::setToRecord()
{
	mode = COMBO_REC;
	recMan.reset();
	recMan.PR->setRecording(false);
	recMan.PR->toggleEditing(false);
	recMan.bShowEditPanel = false;
	
}

//--------------------------------------------------------------
void testApp::keyPressed  (int key){
	
	switch( key )
	{
			//case OF_KEY_RIGHT:	grafMan.nextTag(); break;
		case 'p':		grafMan.bPanelOn = !grafMan.bPanelOn; break;
		case 'f':		ofToggleFullscreen(); break;
	}
	
	
	if( key == ' ' &&  mode == COMBO_REC )
	{	
		recMan.PR->toggleRecording();
		if( recMan.PR->bAmRecording ) recMan.bShowEditPanel = false;
		else{
			setToEdit();
		}
		
	}
	
	if( key == OF_KEY_RETURN )
	{
		if( mode == COMBO_REC && !recMan.PR->bAmRecording)
		{
			recMan.bShowEditPanel = false;
			recMan.PR->toggleRecording(true);
		}
		else if( mode == COMBO_REC && recMan.PR->bAmRecording)
		{
			recMan.PR->toggleRecording(false);
			setToEdit();
		}
		else if( mode == COMBO_EDIT )
		{
			setToPlay();
		}
		else if( mode == COMBO_PLAY )
		{
			setToRecord();
		}
		
		
	}
	

	if( recMan.GE->isEnteringName() )
    {
        recMan.GE->editName( key );
        return;
    }
	
	
	if( mode == COMBO_REC)
		recMan.keyPressed(key);
	
	
	

	
}

//--------------------------------------------------------------
void testApp::keyReleased(int key){
	if( mode == COMBO_REC || mode == COMBO_EDIT ) recMan.keyReleased(key);
}

//--------------------------------------------------------------
void testApp::mouseMoved(int x, int y ){
	
	if( mode == COMBO_REC || mode == COMBO_EDIT) recMan.mouseMoved(x,y);
	
	lastX   = x;
	lastY   = y;
}

//--------------------------------------------------------------
void testApp::mouseDragged(int x, int y, int button){
	
	
	if( mode == COMBO_REC || mode == COMBO_EDIT) recMan.mouseDragged(x,y,button);
	if( mode == COMBO_PLAY ) grafMan.panel.mouseDragged(x, y, button); 
	
	
	if( mode == COMBO_PLAY ) 
	{
		if( button == 0  )
		{
			if( bShiftOn )
			{
				grafMan.adjustTagRot(x-lastX,0);
			}else{
				
				grafMan.adjustTagPos(x-lastX,y-lastY,0);
			}
			
		}else{
			
			
			if( bShiftOn )
			{
				grafMan.adjustTagRot(0,y-lastY);
			}else{
				
				grafMan.adjustTagPos(0,0,y - lastY);
			}
		}
		
	}
	
	lastX   = x;
	lastY   = y;
	
}

//--------------------------------------------------------------
void testApp::mousePressed(int x, int y, int button){
	
    if( mode == COMBO_REC || mode == COMBO_EDIT) recMan.mousePressed(x,y,button);
		
	if( mode == COMBO_PLAY ) grafMan.panel.mousePressed(x, y, button);
	
	lastX = x;
	lastY = y;
	
	if(glutGetModifiers() == GLUT_ACTIVE_SHIFT) bShiftOn = true;
	recMan.bShiftOn = bShiftOn;
	
	//grafMan->updateGuiPress(x,y);
	
}

//--------------------------------------------------------------
void testApp::mouseReleased(int x, int y, int button){
	
	if( mode == COMBO_REC || mode == COMBO_EDIT) recMan.mouseReleased(x,y,button);
	
	if( mode == COMBO_PLAY ) grafMan.panel.mouseReleased();
	bShiftOn = false;
	
	
}

//--------------------------------------------------------------
void testApp::resized(int w, int h){

}

