#ifndef GRECORDER_H
#define GRECORDER_H

#include "pointRecorder.h"
#include "ofxVectorMath.h"
#include "ofxXmlSettings.h"

enum{ DRAW_NORML, DRAW_EDIT, DRAW_CURVE };

class gRecorder : public pointRecorder
{
    public:
        gRecorder();
        virtual ~gRecorder();

        void setup( float width, float height);
        void clear();

        // update
        void update(ofPoint pt);

        // create a new point and add to end of pts vector
        // pt :     (normalized) position of new point
        // dist :   distance of this point to last (used for line width calculations). If valuse = -1 it will calculate distance from previous point
        // angle:   angle of this point to last. If value = -1 it will calculate to previous
        // time:    time stamp associated with this new point. If value = -1, time is based on elapsedTime - startTime
        bool addNewPoint(ofPoint pt);
        bool addLoadedPoint(ofPoint pt, float dist = -1, float angle = -1, float time = -1, bool bAverage = false);

        // drawing
        void draw(float scale);

        // controls
        void setRecording(bool bOn);
		void toggleRecording();
		void toggleRecording(bool bOff);
        void togglePaused();

        // for editing points
        void    setEndPt(int val);
	
        void    setStartPt(int val);
        int     getStartPt(){ return ptStart;}
        int     getEndPt(){ return ptEnd; }
        void    resetForEditing();
        void    calcMinMax();

        // data
        ofPoint getPointForTime(float time, int & whatPointAmI, float & dist, float & angle);
        ofPoint getVelocityForTime(float time);
        float   getDuration();
        int     getNumPts(){ return pts.size(); }
        float   getCurrentTime(){ return timeInRange; };
        float   getCurentZDepth();
        ofPoint getCurrentPoint();
        int     getIdCurrent(){    return lastPoint;     };


        void toggleEditing(bool bEditing);

        // io
        void    saveToXML( string filename );
        void    loadFromXML( string filename );

        float       width, height;              // the drawing space (eitehr camera cap dimensions or screen dims when using mouse)
        bool        bReset;

        vector<float>angles;                    // angles from point to prev
        vector<float>dists;                     // distances from point to prev
        vector<timePt>pts_orig;                 // stores original points so we can change start and end

        ofxVec3f    rotation;
		ofxVec3f    position;
        float       z_const;                    // scale z_depth by this amount to have flatter images

        ofTrueTypeFont  font;

    protected:


        void updateMinMax(int i);

        void drawTimeStroked();
        void drawTimeline(float scale);
        void drawArrow();
        void drawWireframe();
        void drawCurved();
        void drawEdit();
        void drawTangentPoint( ofPoint pt, float  time, float dist, float angle );


        // timing
        float       timeCounter;                // time change for playback
        float       timeOfLastFrame;            // records last time to calc time change
        float       timeInRange;                // current time in the drawing
        float       frameRateCounter;           // counter for recording in sync with camera framerate
        float       fps;                        // framerate of camera capture ( 30fps fps = 1/30 )

        int         lastPoint;                  // last point recorder or last point to be drawn
        float       lastDist;                   // time interpolated distance
        float       lastAngle;                  // time interpolated angle
        ofPoint     pointForTime;               // time interpolated point
        int         ptStart, ptEnd;             // start and end points. if not edited ptStart = 0 and ptEnd = lastPoint


        ofxVec3f    max;                       // min and max pts of drawing
        ofxVec3f    min;

        vector<ofPoint> leftPts;              // pts to make drawing of tangent lines faster
        vector<ofPoint> rightPts;

        int drawMode;
        bool bPause;



    private:
};

#endif // GRAFRECORDER_H
