#ifndef _REC_APP
#define _REC_APP


#include "ofMain.h"
#include "ofxOpenCv.h"
#include "ofxXmlSettings.h"
#include "gRecorder.h"
#include "tracker.h"
#include "grafEditor.h"
#include "grafIO.h"
#include "ofxControlPanel.h"

enum{
MOUSE_NONE,MOUSE_ZOOM,MOUSE_TRANSLATE,MOUSE_ROTATE
};


class recordingApp{

	public:

		recordingApp();
		void setup();
		void update();
		void draw();
		void reset();
	
		void keyPressed  (int key);
		void keyReleased(int key);
		void mouseMoved(int x, int y );
		void mouseDragged(int x, int y, int button);
		void mousePressed(int x, int y, int button);
		void mouseReleased(int x, int y, int button);

		void loadConfigSettings(string filename);

        //----------- video input
        ofBaseVideo     * videoSource;

		//---------- tracking
		tracker         * TR;

		//---------- point recording
		gRecorder    * PR;
		grafEditor      * GE;

		//---------- save and load
		grafIO          * DM;

		//---------- application settings
		bool            bUseVideoFiles;
        bool            bUseMouseCapture;
        bool            bShowCVPanel;
        bool            bShowEditPanel;
        bool            bShowInfo;
        bool            bShiftOn;

        int             camW,camH,camId;
        int             screenW,screenH;
        float           lastX, lastY;
		int             mouse_mode;
		
		float			zoom;
		bool			bZooming;
	
		ofxControlPanel	panel;



};

#endif
