#ifndef TRACKER_H
#define TRACKER_H

#include "ofMain.h"
#include "ofxOpenCv.h"
#include "ofxXmlSettings.h"

#include "guiSlider.h"
#include "guiButton.h"
#include "guiButtonGroup.h"

enum{
TRACK_BRIGHT, TRACK_MOTION, TRACK_BG_SUBTRACT
};

class tracker
{
    public:
        tracker();
        virtual ~tracker();

        void setup( int w, int h );
        void update( unsigned char * pixels );
        void draw();

        float getX();
        float getY();

        void saveToXML( string filename );
        void loadFromXML( string filename );

        void setupGui();
        void drawGui();
        void updateGui();

        void mouseMoved(int x, int y );
		void mouseDragged(int x, int y, int button);
		void mousePressed(int x, int y, int button);
		void mouseReleased(int x, int y, int button);



        ofxCvColorImage     capturedImageData;
		ofxCvGrayscaleImage grayImageData;
		ofxCvGrayscaleImage backgroundData;
		ofxCvGrayscaleImage thresholdImage;
		ofxCvGrayscaleImage prevFrameImage;

		ofxCvContourFinder  contourFinder;

		bool        bFlipH, bFlipV;
		int         width, height;
        int         mode;

        // filtering
        float       threshold;


		bool        bCaptureBg;
		bool		bUseDilate;
		int			nDilations;

		// gui
		guiSlider           slider_threshold;
		guiButtonGroup      button_mode;
		guiButton           button_bgCapture;



    protected:
    private:
};

#endif // TRACKER_H
